package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.NonNull;

/**
 * 商店应用获取 app_access_token的请求体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record PostAuthV3AppAccessTokenRequestBody(
        // 应用唯一标识，创建应用后获得。有关app_id 的详细介绍。请参考通用参数 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2 介绍
        @NonNull String appId,
        // 应用秘钥，创建应用后获得。有关 app_secret 的详细介绍，请参考通用参数 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2 介绍
        @NonNull String appSecret,
        // 平台定时推送给应用的临时凭证，通过事件监听机制获得。有关 app_ticket 的详细介绍，请参考通用参数 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2
        @NonNull String appTicket
) {
}
