package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.NonNull;

/**
 * 自建应用获取 tenant_access_token的请求体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record PostAuthV3TenantAccessTokenInternalRequestBody(
        // 应用唯一标识，创建应用后获得。有关app_id 的详细介绍。请参考通用参数 https://open.feishu.cn/document/ukTMukTMukTM/uYTM5UjL2ETO14iNxkTN/terminology 介绍
        @NonNull String appId,
        // 应用秘钥，创建应用后获得。有关 app_secret 的详细介绍，请参考通用参数 https://open.feishu.cn/document/ukTMukTMukTM/uYTM5UjL2ETO14iNxkTN/terminology 介绍
        @NonNull String appSecret
) {
}
