package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.NonNull;

/**
 * 商店应用获取 tenant_access_token的请求体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record PostAuthV3TenantAccessTokenRequestBody(
        // 应用访问凭证，通过商店应用获取 app_access_token https://open.feishu.cn/document/ukTMukTMukTM/ukDNz4SO0MjL5QzM/auth-v3/auth/app_access_token 接口获取
        @NonNull String appAccessToken,
        // 租户在飞书上的唯一标识，也可以理解为企业标识可以通过如下方式获取：
        // 业开通应用时，开放平台推送给应用，具体可参考首次启用应用 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/application-v6/event/app-first-enabled
        // 用户登录到小程序、H5 应用或者浏览器应用时，在用户的身份信息中获取
        @NonNull String tenantKey
) {
}
