package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.NonNull;
import okhttp3.MediaType;

/**
 * 上传图片的请求体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record PostIMV1ImageRequestBody(
        // 图片类型 message/avatar
        @NonNull ImageType imageType,
        // 图片内容 注意： 上传的图片大小不能超过10MB
        @NonNull Image image
) implements MultipartBodyFieldResolverGenerator {

    @Override
    public @NonNull MediaType type() {
        return okhttp3.MultipartBody.FORM;
    }
}
