package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.NonNull;

/**
 * 回复消息的请求体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record PostIMV1MessagesMessageIdReplyRequestBody(
        // 消息内容 json 格式，格式说明参考: 发送消息Content https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/im-v1/message/create_json
        @NonNull String content,
        // 消息类型，包括：text、post、image、file、audio、media、sticker、interactive、share_card、share_user
        @NonNull String msgType,
        // 由开发者生成的唯一字符串序列，用于回复消息请求去重；持有相同uuid的请求1小时内至多成功执行一次
        String uuid
) {
}
