package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.NonNull;

/**
 * 发送消息的请求体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record PostIMV1MessagesRequestBody(
        // 消息接收者的ID，ID类型应与查询参数receive_id_type 对应；推荐使用 OpenID，获取方式可参考文档如何获取 Open ID？ https://open.feishu.cn/document/uAjLw4CM/ugTN1YjL4UTN24CO1UjN/trouble-shooting/how-to-obtain-openid
        @NonNull String receiveId,
        // 消息类型 包括：text、post、image、file、audio、media、sticker、interactive、share_chat、share_user等，类型定义请参考发送消息Content https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/im-v1/message/create_json
        @NonNull String msgType,
        // 消息内容，JSON结构序列化后的字符串。不同msg_type对应不同内容，具体格式说明参考：发送消息Content https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/im-v1/message/create_json
        // 注意：
        // JSON字符串需进行转义，如换行符转义后为\\n
        // 文本消息请求体最大不能超过150KB
        // 卡片及富文本消息请求体最大不能超过30KB
        @NonNull String content,
        // 由开发者生成的唯一字符串序列，用于发送消息请求去重；持有相同uuid的请求1小时内至多成功发送一条消息
        String uuid
) {
}
