package cn.duskykite.open.call.requestbody;

import lombok.Builder;
import lombok.Getter;
import lombok.NonNull;
import lombok.experimental.SuperBuilder;

import java.util.List;

/**
 * 延时更新消息卡片的请求体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@Builder
public record PostInteractiveV1CardUpdateRequestBody(
        // 用于更新卡片的token，不是tenant_access_token（可通过卡片交互返回内容 https://open.feishu.cn/document/ukTMukTMukTM/uEzNwUjLxcDM14SM3ATN 获取）
        @NonNull String token,
        // 消息卡片的描述内容，具体参考卡片结构 https://open.feishu.cn/document/ukTMukTMukTM/uEjNwUjLxYDM14SM2ATN
        @NonNull Card card
) {

    /**
     * 消息卡片的描述内容，具体参考 <a href="https://open.feishu.cn/document/ukTMukTMukTM/uEjNwUjLxYDM14SM2ATN">卡片结构</a>
     * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
     */
    @SuperBuilder
    @Getter
    public abstract static class Card implements cn.duskykite.open.call.requestbody.Card {

        /**
         * 指定需要更新的用户，共享卡片默认更新所有人卡片，无需填写该字段。推荐使用 OpenID，获取方式可参考文档<a href="https://open.feishu.cn/document/uAjLw4CM/ugTN1YjL4UTN24CO1UjN/trouble-shooting/how-to-obtain-openid">如何获取 Open ID？</a>
         */
        private final List<String> openIds;
    }
}
