package cn.duskykite.open.call.result;

import cn.duskykite.open.Tos;
import cn.duskykite.open.call.Result;
import lombok.Getter;
import lombok.ToString;

import java.time.Duration;

/**
 * 商店应用获取 app_access_token的响应体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@ToString
@Getter
public class PostAuthV3AppAccessTokenResult extends Result {

    /**
     * 应用访问凭证
     */
    private String appAccessToken;

    /**
     * app_access_token 的过期时间，单位为秒
     */
    private Integer expire;

    /**
     * @return app_access_token 的过期时间（生效持续时间）
     */
    public Duration get$Expire() {
        return Tos.durationOfSecond(expire);
    }
}
