package cn.duskykite.open.call.result;

import cn.duskykite.open.Tos;
import cn.duskykite.open.call.Result;
import lombok.Getter;
import lombok.ToString;

import java.time.Duration;

/**
 * 自建应用获取 tenant_access_token的响应体
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@ToString
@Getter
public class PostAuthV3TenantAccessTokenInternalResult extends Result {

    /**
     * 租户访问凭证
     */
    private String tenantAccessToken;

    /**
     * tenant_access_token 的过期时间，单位为秒
     */
    private Integer expire;

    /**
     * @return tenant_access_token 的过期时间（生效持续时间）
     */
    public Duration get$Expire() {
        return Tos.durationOfSecond(expire);
    }
}
