package cn.duskykite.open.call.result.data;

/**
 * 群聊
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record Chat(
        // 群组 ID，详情参见群ID 说明 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/chat-id-description
        String chatId,
        // 群头像 URL
        String avatar,
        // 群名称
        String name,
        // 群描述
        String description,
        // 群主 ID
        String ownerId,
        // 群主 ID 类型
        String ownerIdType,
        // 是否是外部群
        Boolean external,
        // 租户Key，为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用中的唯一标识
        String tenantKey
) {

    /**
     * @return 群主 ID 类型（枚举）
     */
    public UserIdTypeEnum $ownerIdType() {
        return UserIdTypeEnum.getByType(ownerIdType);
    }
}
