package cn.duskykite.open.call.result.data;

/**
 * 群聊成员
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record ChatMember(
        // 成员的用户 ID 类型，与查询参数中的 member_id_type 相同。取值为：open_id、user_id、union_id其中之一。
        String memberIdType,
        // 成员的用户ID，ID值与查询参数中的 member_id_type 对应。
        //不同 ID 的说明参见用户相关的 ID 概念 https://open.feishu.cn/document/home/user-identity-introduction/introduction
        String memberId,
        // 名字
        String name,
        // 租户Key，为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用中的唯一标识
        String tenantKey
) {
}
