package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Enums;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 国家或地区Code缩写枚举类，具体写入格式请参考 <a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/user/country-code-description">国家/地区码表</a>
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum CountryCodeEnum {
    /**
     * 爱尔兰
     */
    IRELAND("IE"),
    /**
     * 埃及
     */
    EGYPT("EG"),
    /**
     * 埃塞俄比亚
     */
    ETHIOPIA("ET"),
    /**
     * 爱沙尼亚
     */
    ESTONIA("EE"),
    /**
     * 安道尔
     */
    ANDORRA("AD"),
    /**
     * 安哥拉
     */
    ANGOLA("AO"),
    /**
     * 安圭拉
     */
    ANGUILLA("AI"),
    /**
     * 安提瓜和巴布达
     */
    ANTIGUA_AND_BARBUDA("AG"),
    /**
     * 澳大利亚
     */
    AUSTRALIA("AU"),
    /**
     * 奥地利
     */
    AUSTRIA("AT"),
    /**
     * 奥兰群岛
     */
    ALAND_ISLANDS("AX"),
    /**
     * 中国澳门
     */
    MACAO_CHINA("MO"),
    /**
     * 阿尔巴尼亚
     */
    ALBANIA("AL"),
    /**
     * 阿尔及利亚
     */
    ALGERIA("DZ"),
    /**
     * 阿富汗
     */
    AFGHANISTAN("AF"),
    /**
     * 阿根廷
     */
    ARGENTINA("AR"),
    /**
     * 阿拉伯联合酋长国
     */
    UNITED_ARAB_EMIRATES("AE"),
    /**
     * 阿鲁巴
     */
    ARUBA("AW"),
    /**
     * 阿曼
     */
    OMAN("OM"),
    /**
     * 阿塞拜疆
     */
    AZERBAIJAN("AZ"),
    /**
     * 白俄罗斯
     */
    BELARUS("BY"),
    /**
     * 百慕大
     */
    BERMUDA("BM"),
    /**
     * 保加利亚
     */
    BULGARIA("BG"),
    /**
     * 巴巴多斯
     */
    BARBADOS("BB"),
    /**
     * 巴布亚新几内亚
     */
    PAPUA_NEW_GUINEA("PG"),
    /**
     * 巴哈马
     */
    BAHAMAS("BS"),
    /**
     * 巴基斯坦
     */
    PAKISTAN("PK"),
    /**
     * 巴拉圭
     */
    PARAGUAY("PY"),
    /**
     * 巴勒斯坦领土
     */
    PALESTINIAN_TERRITORIES("PS"),
    /**
     * 巴林
     */
    BAHRAIN("BH"),
    /**
     * 巴拿马
     */
    PANAMA("PA"),
    /**
     * 巴西
     */
    BRAZIL("BR"),
    /**
     * 北马里亚纳群岛
     */
    NORTHERN_MARIANA_ISLANDS("MP"),
    /**
     * 贝宁
     */
    BENIN("BJ"),
    /**
     * 冰岛
     */
    ICELAND("IS"),
    /**
     * 比利时
     */
    BELGIUM("BE"),
    /**
     * 博茨瓦纳
     */
    BOTSWANA("BW"),
    /**
     * 波多黎各
     */
    PUERTO_RICO("PR"),
    /**
     * 波兰
     */
    POLAND("PL"),
    /**
     * 玻利维亚
     */
    BOLIVIA("BO"),
    /**
     * 伯利兹
     */
    BELIZE("BZ"),
    /**
     * 波斯尼亚和黑塞哥维那
     */
    BOSNIA_AND_HERZEGOVINA("BA"),
    /**
     * 不丹
     */
    BHUTAN("BT"),
    /**
     * 布基纳法索
     */
    BURKINA_FASO("BF"),
    /**
     * 布隆迪
     */
    BURUNDI("BI"),
    /**
     * 秘鲁
     */
    PERU("PE"),
    /**
     * 赤道几内亚
     */
    EQUATORIAL_GUINEA("GQ"),
    /**
     * 朝鲜
     */
    NORTH_KOREA("KP"),
    /**
     * 丹麦
     */
    DENMARK("DK"),
    /**
     * 德国
     */
    GERMANY("DE"),
    /**
     * 迭戈·加西亚
     */
    DIEGO_GARCIA("DG"),
    /**
     * 东帝汶
     */
    EAST_TIMOR("TL"),
    /**
     * 多哥
     */
    TOGO("TG"),
    /**
     * 多米尼加共和国
     */
    DOMINICAN_REPUBLIC("DO"),
    /**
     * 多米尼克
     */
    DOMINICA("DM"),
    /**
     * 厄瓜多尔
     */
    ECUADOR("EC"),
    /**
     * 厄立特里亚
     */
    ERITREA("ER"),
    /**
     * 俄罗斯
     */
    RUSSIA("RU"),
    /**
     * 梵蒂冈
     */
    VATICAN("VA"),
    /**
     * 法国
     */
    FRANCE("FR"),
    /**
     * 法罗群岛
     */
    FAROE_ISLANDS("FO"),
    /**
     * 法属波利尼西亚
     */
    FRENCH_POLYNESIA("PF"),
    /**
     * 法属圭亚那
     */
    FRENCH_GUIANA("GF"),
    /**
     * 斐济
     */
    FIJI("FJ"),
    /**
     * 菲律宾
     */
    PHILIPPINES("PH"),
    /**
     * 芬兰
     */
    FINLAND("FI"),
    /**
     * 佛得角
     */
    CAPE_VERDE("CV"),
    /**
     * 福克兰群岛
     */
    FALKLAND_ISLANDS("FK"),
    /**
     * 冈比亚
     */
    GAMBIA("GM"),
    /**
     * 刚果（布）
     */
    REPUBLIC_OF_THE_CONGO("CG"),
    /**
     * 刚果（金）
     */
    DEMOCRATIC_REPUBLIC_OF_THE_CONGO("CD"),
    /**
     * 格恩西岛
     */
    GUERNSEY("GG"),
    /**
     * 格陵兰
     */
    GREENLAND("GL"),
    /**
     * 格林纳达
     */
    GRENADA("GD"),
    /**
     * 哥伦比亚
     */
    COLOMBIA("CO"),
    /**
     * 格鲁吉亚
     */
    GEORGIA("GE"),
    /**
     * 哥斯达黎加
     */
    COSTA_RICA("CR"),
    /**
     * 关岛
     */
    GUAM("GU"),
    /**
     * 瓜德罗普
     */
    GUADELOUPE("GP"),
    /**
     * 圭亚那
     */
    GUYANA("GY"),
    /**
     * 古巴
     */
    CUBA("CU"),
    /**
     * 海地
     */
    HAITI("HT"),
    /**
     * 韩国
     */
    SOUTH_KOREA("KR"),
    /**
     * 哈萨克斯坦
     */
    KAZAKHSTAN("KZ"),
    /**
     * 黑山
     */
    MONTENEGRO("ME"),
    /**
     * 荷兰
     */
    NETHERLANDS("NL"),
    /**
     * 荷属加勒比区
     */
    DUTCH_CARIBBEAN("BQ"),
    /**
     * 洪都拉斯
     */
    HONDURAS("HN"),
    /**
     * 柬埔寨
     */
    CAMBODIA("KH"),
    /**
     * 加纳
     */
    GHANA("GH"),
    /**
     * 加拿大
     */
    CANADA("CA"),
    /**
     * 加蓬
     */
    GABON("GA"),
    /**
     * 捷克
     */
    CZECH("CZ"),
    /**
     * 津巴布韦
     */
    ZIMBABWE("ZW"),
    /**
     * 吉布提
     */
    DJIBOUTI("DJ"),
    /**
     * 吉尔吉斯斯坦
     */
    KYRGYZSTAN("KG"),
    /**
     * 基里巴斯
     */
    KIRIBATI("KI"),
    /**
     * 几内亚
     */
    GUINEA("GN"),
    /**
     * 几内亚比绍
     */
    GUINEA_BISSAU("GW"),
    /**
     * 开曼群岛
     */
    CAYMAN_ISLANDS("KY"),
    /**
     * 喀麦隆
     */
    CAMEROON("CM"),
    /**
     * 肯尼亚
     */
    KENYA("KE"),
    /**
     * 科科斯（基林）群岛
     */
    COCOS_KEELING_ISLANDS("CC"),
    /**
     * 克罗地亚
     */
    CROATIA("HR"),
    /**
     * 科摩罗
     */
    COMOROS("KM"),
    /**
     * 科特迪瓦
     */
    COTE_D_IVOIRE("CI"),
    /**
     * 科威特
     */
    KUWAIT("KW"),
    /**
     * 库克群岛
     */
    COOK_ISLANDS("CK"),
    /**
     * 库拉索
     */
    CURACAO("CW"),
    /**
     * 卡塔尔
     */
    QATAR("QA"),
    /**
     * 莱索托
     */
    LESOTHO("LS"),
    /**
     * 老挝
     */
    LAOS("LA"),
    /**
     * 拉脱维亚
     */
    LATVIA("LV"),
    /**
     * 列支敦士登
     */
    LIECHTENSTEIN("LI"),
    /**
     * 留尼汪
     */
    REUNION("RE"),
    /**
     * 黎巴嫩
     */
    LEBANON("LB"),
    /**
     * 利比里亚
     */
    LIBERIA("LR"),
    /**
     * 利比亚
     */
    LIBYA("LY"),
    /**
     * 立陶宛
     */
    LITHUANIA("LT"),
    /**
     * 罗马尼亚
     */
    ROMANIA("RO"),
    /**
     * 卢森堡
     */
    LUXEMBOURG("LU"),
    /**
     * 卢旺达
     */
    RWANDA("RW"),
    /**
     * 毛里求斯
     */
    MAURITIUS("MU"),
    /**
     * 毛里塔尼亚
     */
    MAURITANIA("MR"),
    /**
     * 马达加斯加
     */
    MADAGASCAR("MG"),
    /**
     * 马恩岛
     */
    ISLE_OF_MAN("IM"),
    /**
     * 马尔代夫
     */
    MALDIVES("MV"),
    /**
     * 马耳他
     */
    MALTA("MT"),
    /**
     * 马来西亚
     */
    MALAYSIA("MY"),
    /**
     * 马拉维
     */
    MALAWI("MW"),
    /**
     * 马里
     */
    MALI("ML"),
    /**
     * 马其顿
     */
    MACEDONIA("MK"),
    /**
     * 马绍尔群岛
     */
    MARSHALL_ISLANDS("MH"),
    /**
     * 马提尼克
     */
    MARTINIQUE("MQ"),
    /**
     * 马约特
     */
    MAYOTTE("YT"),
    /**
     * 美国
     */
    UNITED_STATES_OF_AMERICA("US"),
    /**
     * 美属萨摩亚
     */
    AMERICAN_SAMOA("AS"),
    /**
     * 美属维尔京群岛
     */
    VIRGIN_ISLANDS_OF_THE_UNITED_STATES("VI"),
    /**
     * 蒙古
     */
    MONGOLIA("MN"),
    /**
     * 孟加拉国
     */
    BANGLADESH("BD"),
    /**
     * 蒙特塞拉特
     */
    MONTSERRAT("MS"),
    /**
     * 缅甸
     */
    MYANMAR("MM"),
    /**
     * 密克罗尼西亚
     */
    MICRONESIA("FM"),
    /**
     * 摩尔多瓦
     */
    MOLDOVA("MD"),
    /**
     * 摩洛哥
     */
    MOROCCO("MA"),
    /**
     * 摩纳哥
     */
    MONACO("MC"),
    /**
     * 莫桑比克
     */
    MOZAMBIQUE("MZ"),
    /**
     * 墨西哥
     */
    MEXICO("MX"),
    /**
     * 南非
     */
    SOUTH_AFRICA("ZA"),
    /**
     * 南苏丹
     */
    SOUTH_SUDAN("SS"),
    /**
     * 瑙鲁
     */
    NAURU("NR"),
    /**
     * 纳米比亚
     */
    NAMIBIA("NA"),
    /**
     * 纽埃
     */
    NIUE("NU"),
    /**
     * 尼泊尔
     */
    NEPAL("NP"),
    /**
     * 尼加拉瓜
     */
    NICARAGUA("NI"),
    /**
     * 尼日尔
     */
    NIGER("NE"),
    /**
     * 尼日利亚
     */
    NIGERIA("NG"),
    /**
     * 诺福克岛
     */
    NORFOLK_ISLAND("NF"),
    /**
     * 挪威
     */
    NORWAY("NO"),
    /**
     * 帕劳
     */
    PALAU("PW"),
    /**
     * 皮特凯恩群岛
     */
    PITCAIRN_ISLANDS("PN"),
    /**
     * 葡萄牙
     */
    PORTUGAL("PT"),
    /**
     * 日本
     */
    JAPAN("JP"),
    /**
     * 瑞典
     */
    SWEDEN("SE"),
    /**
     * 瑞士
     */
    SWITZERLAND("CH"),
    /**
     * 塞尔维亚
     */
    SERBIA("RS"),
    /**
     * 塞拉利昂
     */
    SIERRA_LEONE("SL"),
    /**
     * 塞内加尔
     */
    SENEGAL("SN"),
    /**
     * 塞浦路斯
     */
    CYPRUS("CY"),
    /**
     * 塞舌尔
     */
    SEYCHELLES("SC"),
    /**
     * 萨尔瓦多
     */
    EL_SALVADOR("SV"),
    /**
     * 萨摩亚
     */
    SAMOA("WS"),
    /**
     * 沙特阿拉伯
     */
    SAUDI_ARABIA("SA"),
    /**
     * 圣巴泰勒米
     */
    SAINT_BARTHELEMY("BL"),
    /**
     * 圣诞岛
     */
    CHRISTMAS_ISLAND("CX"),
    /**
     * 圣多美和普林西比
     */
    SAO_TOME_AND_PRINCIPE("ST"),
    /**
     * 圣基茨和尼维斯
     */
    SAINT_KITTS_AND_NEVIS("KN"),
    /**
     * 圣卢西亚
     */
    SAINT_LUCIA("LC"),
    /**
     * 圣马丁岛
     */
    SAINT_MARTIN("MF"),
    /**
     * 圣马力诺
     */
    SAN_MARINO("SM"),
    /**
     * 圣皮埃尔和密克隆群岛
     */
    SAINT_PIERRE_AND_MIQUELON("PM"),
    /**
     * 圣文森特和格林纳丁斯
     */
    SAINT_VINCENT_AND_THE_GRENADINES("VC"),
    /**
     * 斯里兰卡
     */
    SRI_LANKA("LK"),
    /**
     * 斯洛伐克
     */
    SLOVAKIA("SK"),
    /**
     * 斯洛文尼亚
     */
    SLOVENIA("SI"),
    /**
     * 斯威士兰
     */
    ESWATINI("SZ"),
    /**
     * 所罗门群岛
     */
    SOLOMON_ISLANDS("SB"),
    /**
     * 索马里
     */
    SOMALIA("SO"),
    /**
     * 苏丹
     */
    SUDAN("SD"),
    /**
     * 苏里南
     */
    SURINAME("SR"),
    /**
     * 泰国
     */
    THAILAND("TH"),
    /**
     * 中国台湾
     */
    TAIWAN_CHINA("TW"),
    /**
     * 汤加
     */
    TONGA("TO"),
    /**
     * 坦桑尼亚
     */
    TANZANIA("TZ"),
    /**
     * 塔吉克斯坦
     */
    TAJIKISTAN("TJ"),
    /**
     * 特克斯和凯科斯群岛
     */
    TURKS_AND_CAICOS_ISLANDS("TC"),
    /**
     * 特立尼达和多巴哥
     */
    TRINIDAD_AND_TOBAGO("TT"),
    /**
     * 托克劳
     */
    TOKELAU("TK"),
    /**
     * 土耳其
     */
    TURKEY("TR"),
    /**
     * 土库曼斯坦
     */
    TURKMENISTAN("TM"),
    /**
     * 突尼斯
     */
    TUNISIA("TN"),
    /**
     * 图瓦卢
     */
    TUVALU("TV"),
    /**
     * 瓦努阿图
     */
    VANUATU("VU"),
    /**
     * 危地马拉
     */
    GUATEMALA("GT"),
    /**
     * 委内瑞拉
     */
    VENEZUELA("VE"),
    /**
     * 文莱
     */
    BRUNEI("BN"),
    /**
     * 乌干达
     */
    UGANDA("UG"),
    /**
     * 乌克兰
     */
    UKRAINE("UA"),
    /**
     * 乌拉圭
     */
    URUGUAY("UY"),
    /**
     * 乌兹别克斯坦
     */
    UZBEKISTAN("UZ"),
    /**
     * 中国香港
     */
    HONG_KONG_CHINA("HK"),
    /**
     * 新加坡
     */
    SINGAPORE("SG"),
    /**
     * 新喀里多尼亚
     */
    NEW_CALEDONIA("NC"),
    /**
     * 新西兰
     */
    NEW_ZEALAND("NZ"),
    /**
     * 匈牙利
     */
    HUNGARY("HU"),
    /**
     * 西班牙
     */
    SPAIN("ES"),
    /**
     * 希腊
     */
    GREECE("GR"),
    /**
     * 叙利亚
     */
    SYRIA("SY"),
    /**
     * 牙买加
     */
    JAMAICA("JM"),
    /**
     * 亚美尼亚
     */
    ARMENIA("AM"),
    /**
     * 也门
     */
    YEMEN("YE"),
    /**
     * 英国
     */
    UNITED_KINGDOM_OF_GREAT_BRITAIN_AND_NORTHERN_IRELAND("GB"),
    /**
     * 英属维尔京群岛
     */
    BRITISH_VIRGIN_ISLANDS("VG"),
    /**
     * 英属印度洋领地
     */
    BRITISH_INDIAN_OCEAN_TERRITORY("IO"),
    /**
     * 印度
     */
    INDIA("IN"),
    /**
     * 印度尼西亚
     */
    INDONESIA("ID"),
    /**
     * 意大利
     */
    ITALY("IT"),
    /**
     * 伊朗
     */
    IRAN("IR"),
    /**
     * 伊拉克
     */
    IRAQ("IQ"),
    /**
     * 以色列
     */
    ISRAEL("IL"),
    /**
     * 约旦
     */
    JORDAN("JO"),
    /**
     * 越南
     */
    VIETNAM("VN"),
    /**
     * 赞比亚
     */
    ZAMBIA("ZM"),
    /**
     * 泽西岛
     */
    JERSEY("JE"),
    /**
     * 乍得
     */
    CHAD("TD"),
    /**
     * 直布罗陀
     */
    GIBRALTAR("GI"),
    /**
     * 智利
     */
    CHILE("CL"),
    /**
     * 中非共和国
     */
    CENTRAL_AFRICAN_REPUBLIC("CF"),
    /**
     * 中国
     */
    CHINA("CN"),
    ;

    /**
     * 根据编码值获取枚举
     * @param code 编码值
     * @return 枚举
     */
    public static CountryCodeEnum getByCode(String code) {
        return Enums.findByIdentifierIfNonnull(code, CountryCodeEnum.class, e -> e.code);
    }

    /**
     * 编码值
     */
    @NonNull
    private final String code;
}
