package cn.duskykite.open.call.result.data;

/**
 * 自定义字段
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record CustomAttr(
        // 自定义字段类型 TEXT/HREF/ENUMERATION/PICTURE_ENUM/GENERIC_USER 具体说明参见常见问题的用户接口相关问题 https://open.feishu.cn/document/ugTN1YjL4UTN24CO1UjN/uQzN1YjL0cTN24CN3UjN#77061525
        String type,
        // 自定义字段ID
        String id,
        // 自定义字段取值
        Value value
) {

    /**
     * @return 类型
     */
    public CustomAttrTypeEnum $type() {
        return CustomAttrTypeEnum.getByName(type);
    }
}
