package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Xs;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 自定义字段类型枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum CustomAttrTypeEnum {
    /**
     * 文本
     */
    TEXT,
    /**
     * 网页
     */
    HREF,
    /**
     * 枚举
     */
    ENUMERATION,
    /**
     * 图片
     */
    PICTURE_ENUM,
    /**
     * 用户
     */
    GENERIC_USER,
    ;

    /**
     * 根据枚举名称获取枚举
     * @param name 枚举名称
     * @return 枚举
     */
    public static CustomAttrTypeEnum getByName(String name) {
        return Xs.findByIdentifierIfNonnull(name, values(), Enum::name);
    }
}
