package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Tos;
import org.checkerframework.checker.nullness.qual.Nullable;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 部门信息
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record Department(
        // 部门名称
        String name,
        // 国际化的部门名称
        I18nName i18nName,
        // 父部门的ID 在根部门下创建新部门，该参数值为 “0”
        String parentDepartmentId,
        // 本部门的自定义部门ID 注意：除需要满足正则规则外，同时不能以od-开头
        String departmentId,
        // 部门的open_id，类型与通过请求的查询参数传入的department_id_type相同
        String openDepartmentId,
        // 部门主管用户ID
        String leaderUserId,
        // 部门群ID
        String chatId,
        // 部门的排序，即部门在其同级部门的展示顺序
        String order,
        // 部门单位自定义ID列表，当前只支持一个
        List<String> unitIds,
        // 部门下用户的个数
        Integer memberCount,
        // 部门状态
        Status status,
        // 部门负责人
        List<Leader> leaders,
        // 部门群雇员类型限制。[]空列表时，表示为无任何雇员类型。类型字段可包含以下值，支持多个类型值；若有多个，用英文','分隔：1、正式员工2、实习生3、外包4、劳务5、顾问6、其他自定义类型字段，可通过下方接口获取到该租户的自定义员工类型的名称，参见获取人员类型 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/employee_type_enum/list 。
        List<Integer> groupChatEmployeeTypes,
        // 是否创建部门群，默认不创建
        Boolean createGroupChat
) {

    /**
     * 根部门的Id
     */
    public static final String ROOT_DEPARTMENT_ID = "0";

    /**
     * @return 部门的排序
     */
    public Long $order() {
        return Tos.$long(order);
    }

    /**
     * @return 部门群雇员类型限制
     */
    public List<@Nullable EmployeeTypeEnum> $groupChatEmployeeTypes() {
        return Optional.ofNullable(groupChatEmployeeTypes).map(types ->
                        types.stream().map(EmployeeTypeEnum::getByType).collect(Collectors.toList()))
                .orElse(null);
    }
}
