package cn.duskykite.open.call.result.data;

import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 部门ID的类型枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum DepartmentIdTypeEnum {
    /**
     * 标识租户内一个唯一的部门，支持自定义或默认生成。详细说明参见<a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview#23857fe0">部门ID说明</a>
     */
    DEPARTMENT_ID("department_id"),
    /**
     * 在某个应用中标识一个部门，同一个 department_id 在不同应用中的 open_department_id 不相同。详细说明参见 <a href="https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview#23857fe0">部门ID说明</a>
     */
    OPEN_DEPARTMENT_ID("open_department_id"),
    ;

    /**
     * 类型值
     */
    @NonNull
    private final String type;
}
