package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Enums;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Optional;

/**
 * 员工类型枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum EmployeeTypeEnum {
    /**
     * 正式员工
     */
    EMPLOYEE(1),
    /**
     * 实习生
     */
    TRAINEE(2),
    /**
     * 外包
     */
    OUTSOURCE(3),
    /**
     * 劳务
     */
    SERVICE(4),
    /**
     * 顾问
     */
    CONSULTANT(5),
    /**
     * 其他自定义类型字段
     */
    CUSTOM(6),
    ;

    /**
     * 根据类型值获取枚举
     * @param type 类型值
     * @return 枚举
     */
    public static EmployeeTypeEnum getByType(Integer type) {
        return Enums.findByIdentifierIfNonnull(type, EmployeeTypeEnum.class, e -> e.type);
    }

    /**
     * 类型值
     */
    private final int type;
}
