package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Xs;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Optional;

/**
 * 性别枚举
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum GenderEnum {
    /**
     * 保密
     */
    PRIVATE(0),
    /**
     * 男
     */
    MALE(1),
    /**
     * 女
     */
    FEMALE(2),
    ;

    /**
     * 根据性别值获取枚举
     * @param gender 性别值
     * @return 枚举
     */
    public static GenderEnum getByGender(Integer gender) {
        return Xs.findByIdentifierIfNonnull(gender, values(), e -> e.gender);
    }

    /**
     * 性别值
     */
    private final int gender;
}
