package cn.duskykite.open.call.result.data;

import java.util.List;

/**
 * 获取通讯录授权范围的数据对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record GetContactV3ScopesData(
        // 已授权部门列表，授权范围为全员可见时返回的是当前企业的所有一级部门列表
        List<String> departmentIds,
        // 已授权用户列表，应用申请了获取用户user_id 权限时返回；当授权范围为全员可见时返回的是当前企业所有顶级部门用户列表
        List<String> userIds,
        // 已授权的用户组，授权范围为全员可见时返回的是当前企业所有用户组
        List<String> groupIds,
        // 是否还有更多项
        Boolean hasMore,
        // 分页标记，当 has_more 为 true 时，会同时返回新的 page_token，否则不返回 page_token
        String pageToken
) implements PageIterator {
}
