package cn.duskykite.open.call.result.data;

import java.util.List;

/**
 * 获取群成员列表的数据对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record GetIMV1ChatsMembersData(
        // 成员列表
        List<ChatMember> items,
        // 分页标记，当 has_more 为 true 时，会同时返回新的 page_token，否则不返回 page_token
        String pageToken,
        // 是否还有更多项
        Boolean hasMore,
        // 成员总数
        Integer memberTotal
) implements PageIterator {

    @Override
    public Boolean hasMore() {
        return hasMore;
    }

    @Override
    public String pageToken() {
        return pageToken;
    }
}
