package cn.duskykite.open.call.result.data;

import lombok.NonNull;

import java.io.Serial;
import java.util.HashMap;

/**
 * 国际化的名称
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public class I18nName extends HashMap<String, String> {

    @Serial
    private static final long serialVersionUID = -247052903660230046L;

    /**
     * 根据语言枚举获取国际化的名称
     * @param localeEnum 语言枚举
     * @return 国际化的名称
     */
    public String get(@NonNull LocaleEnum localeEnum) {
        return get(localeEnum.getLocale());
    }

    /**
     * 获取中文名
     * @return 中文名
     */
    public String getZhCn() {
        return get(LocaleEnum.ZH_CN);
    }

    /**
     * 获取英文名
     * @return 英文名
     */
    public String getEnUs() {
        return get(LocaleEnum.EN_US);
    }

    /**
     * 获取日文名
     * @return 日文名
     */
    public String getJaJp() {
        return get(LocaleEnum.JA_JP);
    }
}
