package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Tos;

import java.time.Instant;
import java.util.List;

/**
 * 发送消息的数据对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record IMV1Messages(
        // 消息id，说明参见：消息ID说明 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2
        String messageId,
        // 根消息id，用于回复消息场景，说明参见：消息ID说明 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2
        String rootId,
        // 父消息的id，用于回复消息场景，说明参见：消息ID说明 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2
        String parentId,
        // 消息类型 包括：text、post、image、file、audio、media、sticker、interactive、share_chat、share_user等，类型定义请参考接收消息Content https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/im-v1/message/events/message_content
        String msgType,
        // 消息生成的时间戳（毫秒）
        String createTime,
        // 消息更新的时间戳（毫秒）
        String updateTime,
        // 消息是否被撤回
        Boolean deleted,
        // 消息是否被更新
        Boolean updated,
        // 所属的群
        String chatId,
        // 发送者，可以是用户或应用
        Sender sender,
        // 消息内容
        Body body,
        // 被@的用户或机器人的id列表
        List<Mention> mentions,
        // 合并转发消息中，上一层级的消息id message_id，说明参见：消息ID说明 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/message/intro#ac79c1c2
        String upperMessageId
) {

    /**
     * @return 消息类型
     */
    public MsgTypeEnum $msgType() {
        return MsgTypeEnum.getByType(msgType);
    }

    /**
     * @return 消息生成的时间
     */
    public Instant $createTime() {
        return Tos.instantOfMillis(createTime);
    }

    /**
     * @return 消息更新的时间
     */
    public Instant $updateTime() {
        return Tos.instantOfMillis(updateTime);
    }
}
