package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Xs;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.Optional;

/**
 * 负责人类型枚举
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum LeaderTypeEnum {
    /**
     * 主负责人
     */
    PRIMARY(1),
    /**
     * 副负责人
     */
    DEPUTY(2),
    ;

    /**
     * 根据类型值获取枚举
     * @param type 类型值
     * @return 枚举
     */
    public static LeaderTypeEnum getByType(Integer type) {
        return Xs.findByIdentifierIfNonnull(type, values(), e -> e.type);
    }

    /**
     * 类型值
     */
    private final int type;
}
