package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Xs;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.util.Optional;

/**
 * 本地化枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum LocaleEnum {

    /**
     * 中文
     */
    ZH_CN("zh_cn"),
    /**
     * 英文
     */
    EN_US("en_us"),
    /**
     * 日文
     */
    JA_JP("ja_jp"),
    ;

    /**
     * 根据本地化值获取枚举
     * @param locale 本地化值
     * @return 枚举
     */
    public static LocaleEnum getByLocale(String locale) {
        return Xs.findByIdentifierIfNonnull(locale, values(), e -> e.locale);
    }

    /**
     * 本地化值
     */
    @NonNull
    private final String locale;
}
