package cn.duskykite.open.call.result.data;

/**
 * 被@的用户或机器人的id列表
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record Mention(
        // 被@的用户或机器人的序号。例如，第3个被@到的成员，值为“@_user_3”
        String key,
        // 被@的用户或者机器人的open_id
        String id,
        //被@的用户或机器人 id 类型，目前仅支持 open_id (什么是 Open ID？ https://open.feishu.cn/document/home/user-identity-introduction/open-id )
        String idType,
        // 被@的用户或机器人的姓名
        String name,
        //  为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用里面的唯一标识
        String tenantKey
) {

    /**
     * @return 被@的用户或机器人 id 类型
     */
    public UserIdTypeEnum $idType() {
        return UserIdTypeEnum.getByType(idType);
    }
}
