package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Enums;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.util.Optional;

/**
 * 消息类型枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum MsgTypeEnum {
    /**
     * 文本
     */
    TEXT("text"),
    /**
     * 富文本
     */
    POST("post"),
    /**
     * 图片
     */
    IMAGE("image"),
    /**
     * 消息卡片
     */
    INTERACTIVE("interactive"),
    /**
     * 分享群名片
     */
    SHARE_CHAT("share_chat"),
    /**
     * 分享个人名片
     */
    SHARE_USER("share_user"),
    /**
     * 语音
     */
    AUDIO("audio"),
    /**
     * 视频
     */
    MEDIA("media"),
    /**
     * 文件
     */
    FILE("file"),
    /**
     * 表情包
     */
    STICKER("sticker"),
    ;

    /**
     * 根据类型值获取枚举
     * @param type 类型值
     * @return 枚举
     */
    public static MsgTypeEnum getByType(String type) {
        return Enums.findByIdentifierIfNonnull(type, MsgTypeEnum.class, e -> e.type);
    }

    /**
     * 类型值
     */
    @NonNull
    private final String type;
}
