package cn.duskykite.open.call.result.data;

import java.util.Comparator;

/**
 * 次序
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record Order(
        // 排序信息对应的部门ID， ID值与查询参数中的department_id_type 对应。
        // 表示用户所在的、且需要排序的部门。
        // 不同 ID 的说明参见及获取方式参见 部门ID说明 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview
        String departmentId,
        // 用户在其直属部门内的排序，数值越大，排序越靠前
        Integer userOrder,
        // 用户所属的多个部门间的排序，数值越大，排序越靠前
        Integer departmentOrder
) {
    /**
     * 正序比较器
     */
    public static final Comparator<Integer> COMPARATOR =
            Comparator.nullsLast(Comparator.<Integer>naturalOrder().reversed());
}
