package cn.duskykite.open.call.result.data;

import lombok.NonNull;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

/**
 * 分页的迭代对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface PageIterator {

    /**
     * @return 是否还有更多项
     */
    Boolean hasMore();

    /**
     * @return 分页标记，当 has_more 为 true 时，会同时返回新的 page_token，否则不返回 page_token
     */
    String pageToken();

    /**
     * @return 是否还有更多项
     */
    default boolean $hasMore() {
        return Boolean.TRUE.equals(hasMore());
    }

    /**
     * @return 分页标记，当 has_more 为 true 时，会同时返回新的 page_token，否则不返回 page_token
     */
    default String $pageToken() {
        return $hasMore() ? Objects.requireNonNull(pageToken()) : null;
    }
}
