package cn.duskykite.open.call.result.data;

import java.util.List;

/**
 * 批量发送消息的数据对象
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record PostMessageV4BatchSendData(
        // 批量消息 ID
        String messageId,
        // 不合法的部门 ID 列表
        List<String> invalidDepartmentIds,
        // 不合法的 open_id 列表
        List<String> invalidOpenIds,
        // 不合法的 user_id 列表（对应V3接口的invalid_employee_ids）
        List<String> invalidUserIds,
        // 不合法的 union_id 列表
        List<String> invalidUnionIds
) {
}
