package cn.duskykite.open.call.result.data;

/**
 * 发送者，可以是用户或应用
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record Sender(
        // 该字段标识发送者的id
        String id,
        // 该字段标识发送者的id类型 open_id/app_id
        String idType,
        // 该字段标识发送者的类型 user/app/anonymous/unknown
        String senderType,
        // 为租户在飞书上的唯一标识，用来换取对应的tenant_access_token，也可以用作租户在应用里面的唯一标识
        String tenantKey
) {

    /**
     * @return 发送者的id类型
     */
    public SenderIdTypeEnum $idType() {
        return SenderIdTypeEnum.getByType(idType);
    }

    /**
     * @return 发送者的类型
     */
    public SenderTypeEnum $senderType() {
        return SenderTypeEnum.getByType(senderType);
    }
}
