package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Xs;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

/**
 * 发送者的id类型枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum SenderIdTypeEnum {
    /**
     * OpenId
     */
    OPEN_ID("open_id"),
    /**
     * 应用Id
     */
    APP_ID("app_id"),
    ;

    /**
     * 根据类型值获取枚举
     * @param type 类型值
     * @return 枚举
     */
    public static SenderIdTypeEnum getByType(String type) {
        return Xs.findByIdentifierIfNonnull(type, values(), e -> e.type);
    }

    /**
     * 类型值
     */
    @NonNull
    private final String type;
}
