package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Xs;
import lombok.Getter;
import lombok.NonNull;
import lombok.RequiredArgsConstructor;

import java.util.Optional;

/**
 * 发送者类型枚举类
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
@RequiredArgsConstructor
@Getter
public enum SenderTypeEnum {
    /**
     * 用户
     */
    USER("user"),
    /**
     * 应用
     */
    APP("app"),
    /**
     * 匿名
     */
    ANONYMOUS("anonymous"),
    /**
     * 未知
     */
    UNKNOWN("unknown"),
    ;

    /**
     * 根据类型值获取枚举
     * @param type 类型值
     * @return 枚举
     */
    public static SenderTypeEnum getByType(String type) {
        return Xs.findByIdentifierIfNonnull(type, values(), e -> e.type);
    }

    /**
     * 类型值
     */
    @NonNull
    private final String type;
}
