package cn.duskykite.open.call.result.data;

import cn.duskykite.open.Tos;

import java.time.Instant;
import java.util.List;

/**
 * 用户
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record User(
        // 用户的union_id，应用开发商发布的不同应用中同一用户的标识，不同ID的说明参见 用户相关的 ID 概念 https://open.feishu.cn/document/home/user-identity-introduction/introduction
        String unionId,
        // 用户的user_id，租户内用户的唯一标识，不同ID的说明参见 用户相关的 ID 概念 https://open.feishu.cn/document/home/user-identity-introduction/introduction
        String userId,
        // 用户的open_id，应用内用户的唯一标识，不同ID的说明参见 用户相关的 ID 概念 https://open.feishu.cn/document/home/user-identity-introduction/introduction
        String openId,
        // 用户名
        String name,
        // 英文名
        String enName,
        // 别名
        String nickname,
        // 邮箱
        // 注意：
        // 非中国大陆手机号成员必须同时添加邮箱
        // 邮箱不可重复
        String email,
        // 手机号，在本企业内不可重复；未认证企业仅支持添加中国大陆手机号，通过飞书认证的企业允许添加海外手机号，注意国际电话区号前缀中必须包含加号 +
        String mobile,
        // 手机号码可见性，true 为可见，false 为不可见，目前默认为 true。不可见时，组织员工将无法查看该员工的手机号码
        Boolean mobileVisible,
        // 性别 0/1/2
        Integer gender,
        // 头像的文件Key，可通过“消息与群组/消息/图片信息”中的“上传图片”接口上传并获取头像文件 Key “上传图片”功能参见上传图片 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/im-v1/image/create
        String avatarKey,
        // 用户头像信息
        Avatar avatar,
        // 用户状态，枚举类型，包括is_frozen、is_resigned、is_activated、is_exited 。
        // 用户状态转移参见：用户状态图 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/user/field-overview#4302b5a1
        Status status,
        // 用户所属部门的ID列表，一个用户可属于多个部门。
        // ID值的类型与查询参数中的department_id_type 对应。
        // 不同 ID 的说明与department_id的获取方式参见 部门ID说明 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/department/field-overview#23857fe0
        List<String> departmentIds,
        // 用户的直接主管的用户ID，ID值与查询参数中的user_id_type 对应。
        // 不同 ID 的说明参见 用户相关的 ID 概念 https://open.feishu.cn/document/home/user-identity-introduction/introduction
        // 获取方式参见如何获取user_id https://open.feishu.cn/document/home/user-identity-introduction/how-to-get
        String leaderUserId,
        // 工作城市
        String city,
        // 国家或地区Code缩写，具体写入格式请参考 国家/地区码表 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/user/country-code-description
        String country,
        // 工位
        String workStation,
        // 入职时间，时间戳格式，表示从1970年1月1日开始所经过的秒数
        Integer joinTime,
        // 是否是租户超级管理员
        Boolean isTenantManager,
        // 工号
        String employeeNo,
        // 员工类型，可选值有：1/2/3/4/5 同时可读取到自定义员工类型的 int 值，可通过下方接口获取到该租户的自定义员工类型的名称，参见获取人员类型 https://open.feishu.cn/document/uAjLw4CM/ukTMukTMukTM/reference/contact-v3/employee_type_enum/list
        Integer employeeType,
        // 用户排序信息。
        // 用于标记通讯录下组织架构的人员顺序，人员可能存在多个部门中，且有不同的排序。
        List<Order> orders,
        // 自定义字段，请确保你的组织管理员已在管理后台/组织架构/成员字段管理/自定义字段管理/全局设置中开启了“允许开放平台 API 调用“，否则该字段不会生效/返回。
        // 更多详情参见用户接口相关问题 https://open.feishu.cn/document/ugTN1YjL4UTN24CO1UjN/uQzN1YjL0cTN24CN3UjN#77061525
        List<CustomAttr> customAttrs,
        // 企业邮箱，请先确保已在管理后台启用飞书邮箱服务
        // 创建用户时，企业邮箱的使用方式参见用户接口相关问题 https://open.feishu.cn/document/ugTN1YjL4UTN24CO1UjN/uQzN1YjL0cTN24CN3UjN#77061525
        String enterpriseEmail,
        // 职务
        String jobTitle,
        // 是否暂停用户
        Boolean isFrozen
) {

    /**
     * @return 性别
     */
    public GenderEnum $gender() {
        return GenderEnum.getByGender(gender);
    }

    /**
     * @return 国家或地区Code缩写
     */
    public CountryCodeEnum $country() {
        return CountryCodeEnum.getByCode(country);
    }

    /**
     * @return 入职时间
     */
    public Instant $joinTime() {
        return Tos.instantOfSecond(joinTime);
    }

    /**
     * @return 员工类型
     */
    public EmployeeTypeEnum $employeeType() {
        return EmployeeTypeEnum.getByType(employeeType);
    }
}
