package cn.duskykite.open.call.result.data;

/**
 * 自定义字段值
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public record Value(
        // 字段类型为TEXT时该参数定义字段值，必填；字段类型为HREF时该参数定义网页标题，必填
        String text,
        // 字段类型为 HREF 时，该参数定义默认 URL，例如手机端跳转小程序，PC端跳转网页
        String url,
        // 字段类型为 HREF 时，该参数定义PC端 URL
        String pcUrl,
        // 字段类型为 ENUMERATION 或 PICTURE_ENUM 时，该参数定义选项值
        String optionId,
        // 选项类型的值。表示 成员详情/自定义字段 中选项选中的值
        String optionValue,
        // 选项类型为图片时，表示图片的名称
        String name,
        // 图片链接
        String pictureUrl,
        // 字段类型为 GENERIC_USER 时，该参数定义引用人员
        GenericUser genericUser
) {
}
