package cn.duskykite.open.call.result.mapper;

import okhttp3.ResponseBody;

import java.io.IOException;
import java.util.Objects;

/**
 * 字节数据的结果转化方法（结果是字节数组，一般为文件数据）
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface ByteResultMapper extends ResultMapper<byte[]> {

    @Override
    default byte[] apply(ResponseBody responseBody) {
        if (Objects.isNull(responseBody)) {
            return null;
        }

        try {
            return responseBody.bytes();
        } catch (IOException e) {
            throw new RuntimeException("read response body as bytes exception", e);
        }
    }
}
