package cn.duskykite.open.call.result.mapper;

import lombok.NonNull;
import okhttp3.ResponseBody;

import java.io.IOException;
import java.util.Objects;

/**
 * Json文本转化成Java对象的结果转化方法
 * @author <a href="mailto:wh1zper@qq.com">wh1zper</a>
 */
public interface JsonResultMapper<T> extends ResultMapper<T> {

    /**
     * 从Json文本转化成Java对象
     * @param jsonText Json文本
     * @return Java对象
     */
    T fromJsonText(@NonNull String jsonText);

    @Override
    default T apply(ResponseBody responseBody) {
        if (Objects.isNull(responseBody)) {
            return null;
        }

        String jsonText;
        try {
            jsonText = responseBody.string();
        } catch (IOException e) {
            throw new RuntimeException("read response body as string exception", e);
        }

        if (jsonText.isBlank()) {
            return null;
        }

        try {
            return fromJsonText(jsonText);
        } catch (Exception e) {
            throw new RuntimeException(String.format("parse json exception: %s", jsonText), e);
        }
    }
}
