/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call;

import cn.duskykite.open.Tos;
import cn.duskykite.open.call.ContentDisposition;
import java.util.Optional;
import lombok.NonNull;
import okhttp3.Headers;

public record Response<T>(int code, @NonNull Headers headers, T result) {
    public Response(int code, @NonNull Headers headers, T result) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
    }

    public boolean is2xxSuccessful() {
        return this.code / 100 == 2;
    }

    public String getHeader(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.headers.get(name);
    }

    public String contentType() {
        return this.getHeader("Content-Type");
    }

    public String contentLength() {
        return this.getHeader("Content-Length");
    }

    public Long $contentLength() {
        return Tos.$long((String)this.contentLength());
    }

    public ContentDisposition contentDisposition() {
        return Optional.ofNullable(this.getHeader("Content-Disposition")).map(ContentDisposition::new).orElse(null);
    }
}

