/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call;

import cn.duskykite.open.GsonSupport;
import cn.duskykite.open.call.Response;
import cn.duskykite.open.call.requestbody.MultipartBodySupplier;
import cn.duskykite.open.call.result.data.PageIterator;
import cn.duskykite.open.call.result.mapper.JsonResultMapper;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SAO {
    @NonNull
    public static final HttpUrl OPENAPI_PRIMARY_URL = Objects.requireNonNull(HttpUrl.parse((String)"https://open.feishu.cn/open-apis"));
    @NonNull
    public static final MediaType APPLICATION_JSON_UTF_8 = Objects.requireNonNull(MediaType.parse((String)"application/json; charset=utf-8"));
    @NonNull
    public static final Headers JSON_CONTENT_TYPE_HEADERS = SAO.toContentTypeHeaders(APPLICATION_JSON_UTF_8);
    @NonNull
    private final HttpUrl primaryURL;
    @NonNull
    private final OkHttpClient client;

    @NonNull
    public static String toAuthorization(@NonNull String token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return "Bearer " + token;
    }

    @NonNull
    public static Headers toContentTypeHeaders(@NonNull MediaType mediaType) {
        if (mediaType == null) {
            throw new NullPointerException("mediaType is marked non-null but is null");
        }
        return Headers.of((String[])new String[]{"Content-Type", mediaType.toString()});
    }

    @NonNull
    public static Headers toAuthorizationHeaders(@NonNull String authorization) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        return Headers.of((String[])new String[]{"Authorization", authorization});
    }

    public static <P extends PageIterator, C> C pagingAll(@NonNull Function<String, ? extends P> paging, C identity, @NonNull BiFunction<C, ? super P, C> accumulator) {
        PageIterator page;
        if (paging == null) {
            throw new NullPointerException("paging is marked non-null but is null");
        }
        if (accumulator == null) {
            throw new NullPointerException("accumulator is marked non-null but is null");
        }
        String pageToken = null;
        do {
            page = (PageIterator)paging.apply(pageToken);
            accumulator.apply(identity, page);
        } while (Objects.nonNull(pageToken = (String)Optional.ofNullable(page).map(PageIterator::$pageToken).orElse(null)));
        return identity;
    }

    protected static @NonNull List<@Nullable String> variables(Object ... variables) {
        return Optional.ofNullable(variables).filter($variables -> ((Object[])$variables).length > 0).map($variables -> Stream.of($variables).map(variable -> Optional.ofNullable(variable).map(Object::toString).orElse(null)).toList()).orElseGet(List::of);
    }

    protected static Headers headers(Headers ... headers) {
        return Optional.ofNullable(headers).filter($headers -> ((Headers[])$headers).length > 0).map($headers -> {
            if (((Headers[])$headers).length == 1) {
                return $headers[0];
            }
            return Stream.of($headers).collect(Headers.Builder::new, Headers.Builder::addAll, (builder, other) -> builder.addAll(other.build())).build();
        }).orElse(null);
    }

    @NonNull
    protected static RequestBody toJsonRequestBody(@NonNull Object body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return RequestBody.create((String)GsonSupport.toJson((Object)body), (MediaType)APPLICATION_JSON_UTF_8);
    }

    @NonNull
    protected static MultipartBody toMultipartBody(@NonNull MultipartBodySupplier supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return supplier.get();
    }

    @NonNull
    protected static <T> JsonResultMapper<T> toJsonResultMapper(@NonNull TypeToken<? extends T> typeToken) {
        if (typeToken == null) {
            throw new NullPointerException("typeToken is marked non-null but is null");
        }
        return jsonText -> GsonSupport.fromJson((String)jsonText, (TypeToken)typeToken);
    }

    @NonNull
    protected <T> Response<T> request(@NonNull UnaryOperator<Request.Builder> method, @NonNull String path, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        Response<T> response;
        block19: {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (path == null) {
                throw new NullPointerException("path is marked non-null but is null");
            }
            if (resultMapper == null) {
                throw new NullPointerException("resultMapper is marked non-null but is null");
            }
            Request.Builder builder = (Request.Builder)method.apply(new Request.Builder());
            if (Objects.nonNull(headers) && headers.size() > 0) {
                builder = builder.headers(headers);
            }
            Request request = builder.url(this.primaryURL + path).build();
            Call call = this.client.newCall(request);
            okhttp3.Response response2 = call.execute();
            try {
                T result;
                ResponseBody body = response2.body();
                try (Closeable ignored = () -> Optional.ofNullable(body).ifPresent(ResponseBody::close);){
                    result = resultMapper.apply(body);
                }
                response = new Response<T>(response2.code(), response2.headers(), result);
                if (response2 == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (response2 != null) {
                        try {
                            response2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("execute http call exception: ", e);
                }
            }
            response2.close();
        }
        return response;
    }

    @NonNull
    protected <T> Response<T> get(@NonNull String path, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(Request.Builder::get, path, headers, resultMapper);
    }

    @NonNull
    protected <T> Response<T> post(@NonNull String path, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.post(body), path, headers, resultMapper);
    }

    @NonNull
    protected <T> Response<T> patch(@NonNull String path, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.patch(body), path, headers, resultMapper);
    }

    @NonNull
    protected <T> Response<T> delete(@NonNull String path, Headers headers, RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.request(builder -> builder.delete(body), path, headers, resultMapper);
    }

    public SAO(@NonNull HttpUrl primaryURL, @NonNull OkHttpClient client) {
        if (primaryURL == null) {
            throw new NullPointerException("primaryURL is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.primaryURL = primaryURL;
        this.client = client;
    }
}

