/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call;

import cn.duskykite.open.call.OpenAPIEnum;
import cn.duskykite.open.call.Response;
import cn.duskykite.open.call.Result;
import cn.duskykite.open.call.SAO;
import cn.duskykite.open.call.requestbody.PatchIMV1MessagesMessageIdRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3AppAccessTokenRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3TenantAccessTokenInternalRequestBody;
import cn.duskykite.open.call.requestbody.PostAuthV3TenantAccessTokenRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1ImageRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1MessagesMessageIdReplyRequestBody;
import cn.duskykite.open.call.requestbody.PostIMV1MessagesRequestBody;
import cn.duskykite.open.call.requestbody.PostInteractiveV1CardUpdateRequestBody;
import cn.duskykite.open.call.requestbody.PostMessageV4BatchSendRequestBody;
import cn.duskykite.open.call.result.DataResult;
import cn.duskykite.open.call.result.PostAuthV3AppAccessTokenResult;
import cn.duskykite.open.call.result.PostAuthV3TenantAccessTokenInternalResult;
import cn.duskykite.open.call.result.PostAuthV3TenantAccessTokenResult;
import cn.duskykite.open.call.result.data.GetContactV3DepartmentsDepartmentIdChildrenData;
import cn.duskykite.open.call.result.data.GetContactV3DepartmentsDepartmentIdData;
import cn.duskykite.open.call.result.data.GetContactV3ScopesData;
import cn.duskykite.open.call.result.data.GetContactV3UsersFindByDepartmentData;
import cn.duskykite.open.call.result.data.GetContactV3UsersUserIdData;
import cn.duskykite.open.call.result.data.GetIMV1ChatsData;
import cn.duskykite.open.call.result.data.GetIMV1ChatsMembersData;
import cn.duskykite.open.call.result.data.IMV1Messages;
import cn.duskykite.open.call.result.data.PostIMV1ImageData;
import cn.duskykite.open.call.result.data.PostMessageV4BatchSendData;
import cn.duskykite.open.call.result.mapper.ByteResultMapper;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.function.Function;
import lombok.NonNull;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SAOs
extends SAO {
    public SAOs(@NonNull HttpUrl primaryURL, @NonNull OkHttpClient client) {
        super(primaryURL, client);
        if (primaryURL == null) {
            throw new NullPointerException("primaryURL is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
    }

    @NonNull
    public Response<PostAuthV3AppAccessTokenResult> postAuthV3AppAccessToken(@NonNull PostAuthV3AppAccessTokenRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.AUTH_V3_APP_ACCESS_TOKEN, null, JSON_CONTENT_TYPE_HEADERS, SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<PostAuthV3AppAccessTokenResult>(){}));
    }

    @NonNull
    public Response<PostAuthV3TenantAccessTokenResult> postAuthV3TenantAccessToken(@NonNull PostAuthV3TenantAccessTokenRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.AUTH_V3_TENANT_ACCESS_TOKEN, null, JSON_CONTENT_TYPE_HEADERS, SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<PostAuthV3TenantAccessTokenResult>(){}));
    }

    @NonNull
    public Response<PostAuthV3TenantAccessTokenInternalResult> postAuthV3TenantAccessTokenInternal(@NonNull PostAuthV3TenantAccessTokenInternalRequestBody body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.AUTH_V3_TENANT_ACCESS_TOKEN_INTERNAL, null, JSON_CONTENT_TYPE_HEADERS, SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<PostAuthV3TenantAccessTokenInternalResult>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3DepartmentsDepartmentIdData>> getContactV3DepartmentsDepartmentId(@NonNull String authorization, @NonNull String departmentId, String userIdType, String departmentIdType) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID, SAOs.variables(departmentId, userIdType, departmentIdType), SAOs.toAuthorizationHeaders(authorization), SAOs.toJsonResultMapper(new TypeToken<DataResult<GetContactV3DepartmentsDepartmentIdData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3DepartmentsDepartmentIdChildrenData>> getContactV3DepartmentsDepartmentIdChildren(@NonNull String authorization, @NonNull String departmentId, String userIdType, String departmentIdType, Boolean fetchChild, Integer pageSize, String pageToken) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_DEPARTMENTS_DEPARTMENT_ID_CHILDREN, SAOs.variables(departmentId, userIdType, departmentIdType, fetchChild, pageSize, pageToken), SAOs.toAuthorizationHeaders(authorization), SAOs.toJsonResultMapper(new TypeToken<DataResult<GetContactV3DepartmentsDepartmentIdChildrenData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3ScopesData>> getContactV3Scopes(@NonNull String authorization, String userIdType, String departmentIdType, String pageToken, Integer pageSize) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_SCOPES, SAOs.variables(userIdType, departmentIdType, pageToken, pageSize), SAOs.toAuthorizationHeaders(authorization), SAOs.toJsonResultMapper(new TypeToken<DataResult<GetContactV3ScopesData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3UsersFindByDepartmentData>> getContactV3UsersFindByDepartment(@NonNull String authorization, String userIdType, String departmentIdType, @NonNull String departmentId, Integer pageSize, String pageToken) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (departmentId == null) {
            throw new NullPointerException("departmentId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_USERS_FIND_BY_DEPARTMENT, SAOs.variables(userIdType, departmentIdType, departmentId, pageSize, pageToken), SAOs.toAuthorizationHeaders(authorization), SAOs.toJsonResultMapper(new TypeToken<DataResult<GetContactV3UsersFindByDepartmentData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetContactV3UsersUserIdData>> getContactV3UsersUserId(@NonNull String authorization, @NonNull String userId, String userIdType, String departmentIdType) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.CONTACT_V3_USERS_USER_ID, SAOs.variables(userId, userIdType, departmentIdType), SAOs.toAuthorizationHeaders(authorization), SAOs.toJsonResultMapper(new TypeToken<DataResult<GetContactV3UsersUserIdData>>(){}));
    }

    @NonNull
    public Response<DataResult<PostIMV1ImageData>> postIMV1Image(@NonNull String authorization, @NonNull PostIMV1ImageRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        MultipartBody multipartBody = SAOs.toMultipartBody(body);
        return this.post(OpenAPIEnum.IM_V1_IMAGE, null, SAOs.headers(SAOs.toAuthorizationHeaders(authorization), SAOs.toContentTypeHeaders(multipartBody.contentType())), (RequestBody)multipartBody, SAOs.toJsonResultMapper(new TypeToken<DataResult<PostIMV1ImageData>>(){}));
    }

    @NonNull
    public Response<DataResult<IMV1Messages>> postIMV1Messages(@NonNull String authorization, @NonNull String receiveIdType, @NonNull PostIMV1MessagesRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (receiveIdType == null) {
            throw new NullPointerException("receiveIdType is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.IM_V1_MESSAGES, SAOs.variables(receiveIdType), SAOs.headers(SAOs.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<DataResult<IMV1Messages>>(){}));
    }

    @NonNull
    public Response<DataResult<Object>> patchIMV1MessagesMessageId(@NonNull String authorization, @NonNull String messageId, @NonNull PatchIMV1MessagesMessageIdRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.patch(OpenAPIEnum.IM_V1_MESSAGES_MESSAGE_ID, SAOs.variables(messageId), SAOs.headers(SAOs.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<DataResult<Object>>(){}));
    }

    @NonNull
    public Response<DataResult<IMV1Messages>> postIMV1MessagesMessageIdReply(@NonNull String authorization, @NonNull String messageId, @NonNull PostIMV1MessagesMessageIdReplyRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.IM_V1_MESSAGES_MESSAGE_ID_REPLY, SAOs.variables(messageId), SAOs.headers(SAOs.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<DataResult<IMV1Messages>>(){}));
    }

    @NonNull
    public Response<byte[]> getIMV1MessagesResources(@NonNull String authorization, @NonNull String messageId, @NonNull String fileKey, @NonNull String type) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (fileKey == null) {
            throw new NullPointerException("fileKey is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.IM_V1_MESSAGES_RESOURCES, SAOs.variables(messageId, fileKey, type), SAOs.toAuthorizationHeaders(authorization));
    }

    @NonNull
    public Response<Result> postInteractiveV1CardUpdate(@NonNull String authorization, @NonNull PostInteractiveV1CardUpdateRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.INTERACTIVE_V1_CARD_UPDATE, null, SAOs.headers(SAOs.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<Result>(){}));
    }

    @NonNull
    public Response<DataResult<PostMessageV4BatchSendData>> postMessageV4BatchSend(@NonNull String authorization, @NonNull PostMessageV4BatchSendRequestBody body) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return this.post(OpenAPIEnum.MESSAGE_V4_BATCH_SEND, null, SAOs.headers(SAOs.toAuthorizationHeaders(authorization), JSON_CONTENT_TYPE_HEADERS), SAOs.toJsonRequestBody(body), SAOs.toJsonResultMapper(new TypeToken<DataResult<PostMessageV4BatchSendData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetIMV1ChatsData>> getIMV1Chats(@NonNull String authorization, String userIdType, String pageToken, Integer pageSize) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.IM_V1_CHATS, SAOs.variables(userIdType, pageToken, pageSize), SAOs.toAuthorizationHeaders(authorization), SAOs.toJsonResultMapper(new TypeToken<DataResult<GetIMV1ChatsData>>(){}));
    }

    @NonNull
    public Response<DataResult<GetIMV1ChatsMembersData>> getIMV1ChatsMembers(@NonNull String authorization, @NonNull String chatId, String memberIdType, String pageToken, Integer pageSize) {
        if (authorization == null) {
            throw new NullPointerException("authorization is marked non-null but is null");
        }
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        return this.get(OpenAPIEnum.IM_V1_CHATS_MEMBERS, SAOs.variables(chatId, memberIdType, pageToken, pageSize), SAOs.toAuthorizationHeaders(authorization), SAOs.toJsonResultMapper(new TypeToken<DataResult<GetIMV1ChatsMembersData>>(){}));
    }

    @NonNull
    private static String toPath(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        return openApiEnum.getPath().resolve(pathVariables);
    }

    @NonNull
    private <T> Response<T> get(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.get(SAOs.toPath(openApiEnum, pathVariables), headers, resultMapper);
    }

    @NonNull
    private Response<byte[]> get(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        return this.get(openApiEnum, pathVariables, headers, new ByteResultMapper(){});
    }

    @NonNull
    private <T> Response<T> post(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.post(openApiEnum.getPath().resolve(pathVariables), headers, body, resultMapper);
    }

    @NonNull
    private <T> Response<T> patch(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, @NonNull RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.patch(SAOs.toPath(openApiEnum, pathVariables), headers, body, resultMapper);
    }

    @NonNull
    private <T> Response<T> delete(@NonNull OpenAPIEnum openApiEnum, Collection<@Nullable String> pathVariables, Headers headers, RequestBody body, @NonNull Function<ResponseBody, ? extends T> resultMapper) {
        if (openApiEnum == null) {
            throw new NullPointerException("openApiEnum is marked non-null but is null");
        }
        if (resultMapper == null) {
            throw new NullPointerException("resultMapper is marked non-null but is null");
        }
        return this.delete(SAOs.toPath(openApiEnum, pathVariables), headers, body, resultMapper);
    }
}

