/*
 * Decompiled with CFR 0.152.
 */
package cn.duskykite.open.call.result.mapper;

import cn.duskykite.open.call.result.mapper.ResultMapper;
import java.io.IOException;
import java.util.Objects;
import lombok.NonNull;
import okhttp3.ResponseBody;

public interface JsonResultMapper<T>
extends ResultMapper<T> {
    public T fromJsonText(@NonNull String var1);

    @Override
    default public T apply(ResponseBody responseBody) {
        String jsonText;
        if (Objects.isNull(responseBody)) {
            return null;
        }
        try {
            jsonText = responseBody.string();
        }
        catch (IOException e) {
            throw new RuntimeException("read response body as string exception", e);
        }
        if (jsonText.isBlank()) {
            return null;
        }
        try {
            return this.fromJsonText(jsonText);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("parse json exception: %s", jsonText), e);
        }
    }
}

