/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.jobless.core;

import cn.dustlight.jobless.core.AbstractJobHandler;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobWorker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobHandlerManager<T> {
    private Map<String, JobWorker> handlerMap;
    private ZeebeClient client;
    private final Log logger = LogFactory.getLog(this.getClass());

    public JobHandlerManager(ZeebeClient client) {
        this(new ConcurrentHashMap<String, JobWorker>(), client);
    }

    public void addHandler(String key, AbstractJobHandler<T> handler) {
        JobWorker oldWorker;
        if (this.handlerMap.containsKey(key) && (oldWorker = this.handlerMap.get(key)) != null) {
            oldWorker.close();
        }
        JobWorker worker = this.client.newWorker().jobType(key).handler(handler).open();
        this.handlerMap.put(key, worker);
        this.logger.info((Object)String.format("Handler up: [%s].", key));
    }

    public void removeHandler(String key) {
        JobWorker worker = this.handlerMap.remove(key);
        if (worker != null) {
            worker.close();
            this.logger.info((Object)String.format("Handler down: [%s].", key));
        }
    }

    public boolean isAnyClosed() {
        for (JobWorker worker : this.handlerMap.values()) {
            if (!worker.isClosed()) continue;
            return true;
        }
        return false;
    }

    public JobHandlerManager(Map<String, JobWorker> handlerMap, ZeebeClient client) {
        this.handlerMap = handlerMap;
        this.client = client;
    }
}

