/*
 * Decompiled with CFR 0.152.
 */
package cn.dustlight.jobless.core;

import cn.dustlight.jobless.core.Utils;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJobHandler<T>
implements JobHandler {
    private T spec;
    private final Log logger = LogFactory.getLog(this.getClass());

    public void handle(JobClient client, ActivatedJob job) {
        Response response;
        try {
            response = this.handle(job, this.spec);
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            response = new Response();
            response.setResult(Result.ERROR);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(byteArrayOutputStream));
            response.errorMessage = e.getMessage() == null ? new String(byteArrayOutputStream.toByteArray()) : e.getMessage();
            response.errorCode = "Internal Server Error";
        }
        switch (response.result) {
            case FAIL: {
                client.newFailCommand(job.getKey()).retries(response.retires).errorMessage(response.errorMessage).send().join();
                break;
            }
            case ERROR: {
                client.newThrowErrorCommand(job.getKey()).errorCode(response.errorCode).errorMessage(response.errorMessage).send().join();
                break;
            }
            default: {
                client.newCompleteCommand(job.getKey()).variables(AbstractJobHandler.newMap(Utils.getSuffix(job.getElementId()), response.variables)).send().join();
            }
        }
    }

    public static Map<String, Object> newMap(String key, Object value) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(key, value);
        return result;
    }

    protected abstract Response handle(ActivatedJob var1, T var2) throws Throwable;

    public AbstractJobHandler(T spec) {
        this.spec = spec;
    }

    public static enum Result {
        COMPLETE,
        FAIL,
        ERROR;

    }

    public static class Response {
        private Result result;
        private String errorCode;
        private String errorMessage;
        private int retires;
        private Map<String, Object> variables;

        public Result getResult() {
            return this.result;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public int getRetires() {
            return this.retires;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public void setResult(Result result) {
            this.result = result;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public void setRetires(int retires) {
            this.retires = retires;
        }

        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }
    }
}

