/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.common.utils;

import cn.easyes.common.utils.ExceptionUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ClassUtils {
    private static final List<String> PROXY_CLASS_NAMES = Arrays.asList("net.sf.cglib.proxy.Factory", "org.springframework.cglib.proxy.Factory", "javassist.util.proxy.ProxyObject", "org.apache.ibatis.javassist.util.proxy.ProxyObject");

    private ClassUtils() {
    }

    public static boolean isProxy(Class<?> clazz) {
        if (clazz != null) {
            for (Class<?> cls : clazz.getInterfaces()) {
                if (!PROXY_CLASS_NAMES.contains(cls.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            throw ExceptionUtils.eee("Class must not be null", new Object[0]);
        }
        return ClassUtils.isProxy(clazz) ? clazz.getSuperclass() : clazz;
    }
}

