/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.common.utils;

import cn.easyes.common.utils.EEVersionUtils;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.common.utils.LogUtils;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public class RestHighLevelClientBuilder {
    private static final String supportedVersion = "7";

    public static RestHighLevelClient build(RestClientBuilder builder) {
        RestHighLevelClient restHighLevelClient = new RestHighLevelClient(builder);
        RestHighLevelClientBuilder.verify(restHighLevelClient);
        return restHighLevelClient;
    }

    private static void verify(RestHighLevelClient restHighLevelClient) {
        String jarVersion = EEVersionUtils.getJarVersion(restHighLevelClient.getClass());
        LogUtils.formatInfo("Elasticsearch jar version:%s", jarVersion);
        if (!jarVersion.startsWith(supportedVersion)) {
            throw ExceptionUtils.eee("Easy-Es supported elasticsearch jar version is:%s.xx", supportedVersion);
        }
        String clientVersion = EEVersionUtils.getClientVersion(restHighLevelClient);
        LogUtils.formatInfo("Elasticsearch client version:%s", clientVersion);
        if (!clientVersion.startsWith(supportedVersion)) {
            LogUtils.formatWarn("Easy-Es supported elasticsearch client version is:%s.xx", supportedVersion);
        }
        if (!jarVersion.equals(clientVersion)) {
            LogUtils.formatWarn("Elasticsearch clientVersion:%s not equals jarVersion:%s", clientVersion, jarVersion);
        }
    }

    private RestHighLevelClientBuilder() {
    }
}

