/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.conditions;

import cn.easyes.common.enums.AggregationTypeEnum;
import cn.easyes.common.enums.BaseEsParamTypeEnum;
import cn.easyes.common.enums.EsAttachTypeEnum;
import cn.easyes.common.enums.EsQueryTypeEnum;
import cn.easyes.common.enums.JoinTypeEnum;
import cn.easyes.common.utils.ArrayUtils;
import cn.easyes.common.utils.Assert;
import cn.easyes.common.utils.CollectionUtils;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.AggregationParam;
import cn.easyes.core.biz.BaseEsParam;
import cn.easyes.core.biz.GeoParam;
import cn.easyes.core.biz.OrderByParam;
import cn.easyes.core.biz.SortParam;
import cn.easyes.core.conditions.Wrapper;
import cn.easyes.core.conditions.interfaces.Compare;
import cn.easyes.core.conditions.interfaces.Func;
import cn.easyes.core.conditions.interfaces.Geo;
import cn.easyes.core.conditions.interfaces.Join;
import cn.easyes.core.conditions.interfaces.Nested;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;

public abstract class AbstractWrapper<T, R, Children extends AbstractWrapper<T, R, Children>>
extends Wrapper<T>
implements Compare<Children, R>,
Nested<Children, Children>,
Join<Children>,
Func<Children, R>,
Geo<Children, R> {
    protected final Children typedThis = this;
    protected List<BaseEsParam> baseEsParamList;
    protected List<SortParam> sortParamList;
    protected List<AggregationParam> aggregationParamList;
    protected String distinctField;
    protected GeoParam geoParam;
    protected List<SortBuilder<?>> sortBuilders;
    protected SortOrder sortOrder;
    protected List<OrderByParam> orderByParams;
    protected Boolean matchAllQuery;
    protected T entity;
    protected Class<T> entityClass;

    public Children setEntity(T entity) {
        this.entity = entity;
        this.initEntityClass();
        return this.typedThis;
    }

    public Children setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.initEntityClass();
        return this.typedThis;
    }

    protected void initEntityClass() {
        if (this.entityClass == null && this.entity != null) {
            this.entityClass = this.entity.getClass();
        }
    }

    protected Class<T> getCheckEntityClass() {
        Assert.notNull(this.entityClass, (String)"entityClass must not null,please set entity before use this method!");
        return this.entityClass;
    }

    protected final void initNeed() {
        this.baseEsParamList = new ArrayList<BaseEsParam>();
        this.sortParamList = new ArrayList<SortParam>();
        this.aggregationParamList = new ArrayList<AggregationParam>();
    }

    @Override
    public <V> Children allEq(boolean condition, Map<String, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (StringUtils.checkValNotNull((Object)v)) {
                    this.eq((String)k, v);
                } else if (null2IsNull) {
                    this.isNull((String)k);
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public <V> Children allEq(boolean condition, BiPredicate<String, V> filter, Map<String, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (filter.test((String)k, (Object)v)) {
                    if (StringUtils.checkValNotNull((Object)v)) {
                        this.eq((String)k, v);
                    } else if (null2IsNull) {
                        this.isNull((String)k);
                    }
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public Children eq(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.TERM_QUERY, EsAttachTypeEnum.MUST, column, val, boost);
    }

    @Override
    public Children ne(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.TERM_QUERY, EsAttachTypeEnum.MUST_NOT, column, val, boost);
    }

    @Override
    public Children and(boolean condition, Function<Children, Children> func) {
        return this.doIt(condition, func, BaseEsParamTypeEnum.AND_LEFT_BRACKET, BaseEsParamTypeEnum.AND_RIGHT_BRACKET);
    }

    @Override
    public Children or(boolean condition, Function<Children, Children> func) {
        return this.doIt(condition, func, BaseEsParamTypeEnum.OR_LEFT_BRACKET, BaseEsParamTypeEnum.OR_RIGHT_BRACKET);
    }

    @Override
    public Children match(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.MATCH_QUERY, EsAttachTypeEnum.MUST, column, val, boost);
    }

    @Override
    public Children nestedMatch(boolean condition, String path, String column, Object val, ScoreMode scoreMode, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.MATCH_QUERY, EsAttachTypeEnum.MUST, JoinTypeEnum.NESTED, path, column, val, scoreMode, boost);
    }

    @Override
    public Children hasChild(boolean condition, String type, String column, Object val, ScoreMode scoreMode, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.MATCH_QUERY, EsAttachTypeEnum.MUST, JoinTypeEnum.HAS_CHILD, type, column, val, scoreMode, boost);
    }

    @Override
    public Children hasParent(boolean condition, String type, String column, Object val, boolean score, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.MATCH_QUERY, EsAttachTypeEnum.MUST, JoinTypeEnum.HAS_PARENT, type, column, val, score, boost);
    }

    @Override
    public Children parentId(boolean condition, Object parentId, String type, Float boost) {
        Assert.notNull((Object)parentId, (String)"parentId could not be null");
        return this.doIt(condition, EsQueryTypeEnum.MATCH_QUERY, EsAttachTypeEnum.MUST, JoinTypeEnum.PARENT_ID, type, null, parentId, null, boost);
    }

    @Override
    public Children matchPhase(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.MATCH_PHASE, EsAttachTypeEnum.MUST, column, val, boost);
    }

    @Override
    public Children matchAllQuery(boolean condition) {
        if (condition) {
            this.matchAllQuery = true;
        }
        return this.typedThis;
    }

    @Override
    public Children matchPhrasePrefixQuery(boolean condition, String column, Object val, int maxExpansions, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.MATCH_PHRASE_PREFIX, EsAttachTypeEnum.MUST, column, val, maxExpansions, boost);
    }

    @Override
    @SafeVarargs
    public final Children multiMatchQuery(boolean condition, Object val, Operator operator, int minimumShouldMatch, Float boost, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        return this.doIt(condition, EsQueryTypeEnum.MULTI_MATCH_QUERY, EsAttachTypeEnum.MUST_MULTI_FIELDS, val, operator, minimumShouldMatch, boost, columns);
    }

    @Override
    public Children queryStringQuery(boolean condition, String queryString, Float boost) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            throw ExceptionUtils.eee((String)"queryString can't be blank", (Object[])new Object[0]);
        }
        return this.doIt(condition, EsQueryTypeEnum.QUERY_STRING_QUERY, EsAttachTypeEnum.MUST, null, (Object)queryString, boost);
    }

    @Override
    public Children prefixQuery(boolean condition, String column, String prefix, Float boost) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            throw ExceptionUtils.eee((String)"prefix can't be blank", (Object[])new Object[0]);
        }
        return this.doIt(condition, EsQueryTypeEnum.PREFIX_QUERY, EsAttachTypeEnum.MUST, column, (Object)prefix, boost);
    }

    @Override
    public Children notMatch(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.MATCH_QUERY, EsAttachTypeEnum.MUST_NOT, column, val, boost);
    }

    @Override
    public Children gt(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.RANGE_QUERY, EsAttachTypeEnum.GT, column, val, boost);
    }

    @Override
    public Children ge(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.RANGE_QUERY, EsAttachTypeEnum.GE, column, val, boost);
    }

    @Override
    public Children lt(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.RANGE_QUERY, EsAttachTypeEnum.LT, column, val, boost);
    }

    @Override
    public Children le(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.RANGE_QUERY, EsAttachTypeEnum.LE, column, val, boost);
    }

    @Override
    public Children between(boolean condition, String column, Object val1, Object val2, Float boost) {
        return this.doIt(condition, EsAttachTypeEnum.BETWEEN, column, val1, val2, boost);
    }

    @Override
    public Children notBetween(boolean condition, String column, Object val1, Object val2, Float boost) {
        return this.doIt(condition, EsAttachTypeEnum.NOT_BETWEEN, column, val1, val2, boost);
    }

    @Override
    public Children or(boolean condition) {
        if (condition) {
            BaseEsParam baseEsParam = new BaseEsParam();
            baseEsParam.setType(BaseEsParamTypeEnum.OR_ALL.getType());
            this.baseEsParamList.add(baseEsParam);
        }
        return this.typedThis;
    }

    @Override
    public Children like(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.WILDCARD_QUERY, EsAttachTypeEnum.MUST, column, val, boost);
    }

    @Override
    public Children notLike(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.WILDCARD_QUERY, EsAttachTypeEnum.MUST_NOT, column, val, boost);
    }

    @Override
    public Children likeLeft(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.WILDCARD_QUERY, EsAttachTypeEnum.LIKE_LEFT, column, val, boost);
    }

    @Override
    public Children likeRight(boolean condition, String column, Object val, Float boost) {
        return this.doIt(condition, EsQueryTypeEnum.WILDCARD_QUERY, EsAttachTypeEnum.LIKE_RIGHT, column, val, boost);
    }

    @Override
    public final Children orderBy(boolean condition, boolean isAsc, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        if (condition) {
            List<String> fields = Arrays.asList(columns);
            this.sortParamList.add(new SortParam(isAsc, fields));
        }
        return this.typedThis;
    }

    @Override
    public Children orderBy(boolean condition, List<OrderByParam> orderByParams) {
        if (CollectionUtils.isNotEmpty(orderByParams)) {
            this.orderByParams = orderByParams;
        }
        return this.typedThis;
    }

    @Override
    public Children in(boolean condition, String column, Collection<?> coll, Float boost) {
        if (CollectionUtils.isEmpty(coll)) {
            return this.typedThis;
        }
        return this.doIt(condition, EsAttachTypeEnum.IN, column, new ArrayList<Object>(coll), boost);
    }

    @Override
    public Children notIn(boolean condition, String column, Collection<?> coll, Float boost) {
        if (CollectionUtils.isEmpty(coll)) {
            return this.typedThis;
        }
        return this.doIt(condition, EsAttachTypeEnum.NOT_IN, column, new ArrayList<Object>(coll), boost);
    }

    @Override
    public Children isNull(boolean condition, String column, Float boost) {
        return this.doIt(condition, EsAttachTypeEnum.NOT_EXISTS, column, boost);
    }

    @Override
    public Children isNotNull(boolean condition, String column, Float boost) {
        return this.doIt(condition, EsAttachTypeEnum.EXISTS, column, boost);
    }

    @Override
    public final Children groupBy(boolean condition, boolean enablePipeline, String ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        Arrays.stream(columns).forEach(column -> this.doIt(condition, enablePipeline, AggregationTypeEnum.TERMS, (String)column, (String)column));
        return this.typedThis;
    }

    @Override
    public Children termsAggregation(boolean condition, boolean enablePipeline, String returnName, String column) {
        return this.doIt(condition, enablePipeline, AggregationTypeEnum.TERMS, returnName, column);
    }

    @Override
    public Children avg(boolean condition, boolean enablePipeline, String returnName, String column) {
        return this.doIt(condition, enablePipeline, AggregationTypeEnum.AVG, returnName, column);
    }

    @Override
    public Children min(boolean condition, boolean enablePipeline, String returnName, String column) {
        return this.doIt(condition, enablePipeline, AggregationTypeEnum.MIN, returnName, column);
    }

    @Override
    public Children max(boolean condition, boolean enablePipeline, String returnName, String column) {
        return this.doIt(condition, enablePipeline, AggregationTypeEnum.MAX, returnName, column);
    }

    @Override
    public Children sum(boolean condition, boolean enablePipeline, String returnName, String column) {
        return this.doIt(condition, enablePipeline, AggregationTypeEnum.SUM, returnName, column);
    }

    @Override
    public Children distinct(boolean condition, String column) {
        if (condition) {
            this.distinctField = column;
        }
        return this.typedThis;
    }

    @Override
    public Children geoBoundingBox(boolean condition, String column, GeoPoint topLeft, GeoPoint bottomRight, Float boost) {
        return this.doIt(condition, column, topLeft, bottomRight, boost, true);
    }

    @Override
    public Children notInGeoBoundingBox(boolean condition, String column, GeoPoint topLeft, GeoPoint bottomRight, Float boost) {
        return this.doIt(condition, column, topLeft, bottomRight, boost, false);
    }

    @Override
    public Children geoDistance(boolean condition, String column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint, Float boost) {
        return this.doIt(condition, column, distance, distanceUnit, centralGeoPoint, boost, true);
    }

    @Override
    public Children notInGeoDistance(boolean condition, String column, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint, Float boost) {
        return this.doIt(condition, column, distance, distanceUnit, centralGeoPoint, boost, false);
    }

    @Override
    public Children geoDistance(boolean condition, String column, String distance, GeoPoint centralGeoPoint, Float boost) {
        return this.doIt(condition, column, distance, centralGeoPoint, boost, true);
    }

    @Override
    public Children notInGeoDistance(boolean condition, String column, String distance, GeoPoint centralGeoPoint, Float boost) {
        return this.doIt(condition, column, distance, centralGeoPoint, boost, false);
    }

    @Override
    public Children geoPolygon(boolean condition, String column, List<GeoPoint> geoPoints, Float boost) {
        return this.doIt(condition, column, geoPoints, boost, true);
    }

    @Override
    public Children notInGeoPolygon(boolean condition, String column, Collection<GeoPoint> geoPoints, Float boost) {
        ArrayList<GeoPoint> geoPointList = new ArrayList<GeoPoint>(geoPoints);
        return this.doIt(condition, column, geoPointList, boost, false);
    }

    @Override
    public Children geoShape(boolean condition, String column, String indexedShapeId, Float boost) {
        return this.doIt(condition, column, indexedShapeId, boost, true);
    }

    @Override
    public Children notInGeoShape(boolean condition, String column, String indexedShapeId, Float boost) {
        return this.doIt(condition, column, indexedShapeId, boost, false);
    }

    @Override
    public Children geoShape(boolean condition, String column, Geometry geometry, ShapeRelation shapeRelation, Float boost) {
        return this.doIt(condition, column, geometry, shapeRelation, boost, true);
    }

    @Override
    public Children notInGeoShape(boolean condition, String column, Geometry geometry, ShapeRelation shapeRelation, Float boost) {
        return this.doIt(condition, column, geometry, shapeRelation, boost, false);
    }

    @Override
    public Children sort(boolean condition, List<SortBuilder<?>> sortBuilders) {
        if (CollectionUtils.isEmpty(sortBuilders)) {
            return this.typedThis;
        }
        if (condition) {
            this.sortBuilders = sortBuilders;
        }
        return this.typedThis;
    }

    @Override
    public Children sortByScore(boolean condition, SortOrder sortOrder) {
        if (condition) {
            this.sortOrder = sortOrder;
        }
        return this.typedThis;
    }

    protected abstract Children instance();

    private Children doIt(boolean condition, boolean enablePipeline, AggregationTypeEnum aggregationTypeEnum, String returnName, String column) {
        if (condition) {
            AggregationParam aggregationParam = new AggregationParam();
            aggregationParam.setEnablePipeline(enablePipeline);
            aggregationParam.setName(returnName);
            aggregationParam.setField(column);
            aggregationParam.setAggregationType(aggregationTypeEnum);
            this.aggregationParamList.add(aggregationParam);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, Function<Children, Children> func, BaseEsParamTypeEnum open, BaseEsParamTypeEnum close) {
        if (condition) {
            BaseEsParam left = new BaseEsParam();
            left.setType(open.getType());
            this.baseEsParamList.add(left);
            func.apply(this.instance());
            BaseEsParam right = new BaseEsParam();
            right.setType(close.getType());
            this.baseEsParamList.add(right);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, EsAttachTypeEnum attachTypeEnum, String field, List<Object> values, Float boost) {
        if (condition) {
            BaseEsParam baseEsParam = new BaseEsParam();
            BaseEsParam.FieldValueModel model = BaseEsParam.FieldValueModel.builder().field(field).values(values).boost(boost).esQueryType(EsQueryTypeEnum.TERMS_QUERY.getType()).originalAttachType(attachTypeEnum.getType()).build();
            this.setModel(baseEsParam, model, attachTypeEnum);
            this.baseEsParamList.add(baseEsParam);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, EsQueryTypeEnum queryTypeEnum, EsAttachTypeEnum attachTypeEnum, String field, Object val, Float boost) {
        return this.doIt(condition, queryTypeEnum, attachTypeEnum, field, val, null, boost);
    }

    private Children doIt(boolean condition, EsQueryTypeEnum queryTypeEnum, EsAttachTypeEnum attachTypeEnum, String field, Object val, Object ext, Float boost) {
        if (condition) {
            BaseEsParam baseEsParam = new BaseEsParam();
            BaseEsParam.FieldValueModel model = BaseEsParam.FieldValueModel.builder().field(field).value(val).boost(boost).esQueryType(queryTypeEnum.getType()).originalAttachType(attachTypeEnum.getType()).ext(ext).build();
            this.setModel(baseEsParam, model, attachTypeEnum);
            this.baseEsParamList.add(baseEsParam);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, EsAttachTypeEnum attachTypeEnum, String field, Float boost) {
        if (condition) {
            BaseEsParam baseEsParam = new BaseEsParam();
            BaseEsParam.FieldValueModel model = BaseEsParam.FieldValueModel.builder().field(field).boost(boost).esQueryType(EsQueryTypeEnum.EXISTS_QUERY.getType()).originalAttachType(attachTypeEnum.getType()).build();
            this.setModel(baseEsParam, model, attachTypeEnum);
            this.baseEsParamList.add(baseEsParam);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, EsAttachTypeEnum attachTypeEnum, String field, Object left, Object right, Float boost) {
        if (condition) {
            BaseEsParam baseEsParam = new BaseEsParam();
            BaseEsParam.FieldValueModel model = BaseEsParam.FieldValueModel.builder().field(field).leftValue(left).rightValue(right).boost(boost).esQueryType(EsQueryTypeEnum.INTERVAL_QUERY.getType()).originalAttachType(attachTypeEnum.getType()).build();
            this.setModel(baseEsParam, model, attachTypeEnum);
            this.baseEsParamList.add(baseEsParam);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, EsQueryTypeEnum queryTypeEnum, EsAttachTypeEnum attachTypeEnum, Object val, Operator operator, int minimumShouldMatch, Float boost, String ... columns) {
        if (condition) {
            BaseEsParam baseEsParam = new BaseEsParam();
            List<String> fields = Arrays.asList(columns);
            BaseEsParam.FieldValueModel model = BaseEsParam.FieldValueModel.builder().fields(fields).value(val).ext(operator).minimumShouldMatch(minimumShouldMatch).boost(boost).esQueryType(queryTypeEnum.getType()).originalAttachType(attachTypeEnum.getType()).build();
            this.setModel(baseEsParam, model, attachTypeEnum);
            this.baseEsParamList.add(baseEsParam);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, EsQueryTypeEnum queryTypeEnum, EsAttachTypeEnum attachTypeEnum, JoinTypeEnum joinTypeEnum, String path, String column, Object val, Object scoreMode, Float boost) {
        if (condition) {
            BaseEsParam baseEsParam = new BaseEsParam();
            BaseEsParam.FieldValueModel model = BaseEsParam.FieldValueModel.builder().field(column).path(path).scoreMode(scoreMode).value(val).boost(boost).ext(joinTypeEnum).esQueryType(queryTypeEnum.getType()).originalAttachType(attachTypeEnum.getType()).build();
            this.setModel(baseEsParam, model, attachTypeEnum);
            this.baseEsParamList.add(baseEsParam);
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, String field, GeoPoint topLeft, GeoPoint bottomRight, Float boost, boolean isIn) {
        if (condition) {
            this.geoParam = GeoParam.builder().field(field).topLeft(topLeft).bottomRight(bottomRight).boost(boost).isIn(isIn).build();
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, String fieldName, Double distance, DistanceUnit distanceUnit, GeoPoint centralGeoPoint, Float boost, boolean isIn) {
        if (condition) {
            this.geoParam = GeoParam.builder().field(fieldName).boost(boost).distance(distance).distanceUnit(distanceUnit).centralGeoPoint(centralGeoPoint).isIn(isIn).build();
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, String fieldName, String distance, GeoPoint centralGeoPoint, Float boost, boolean isIn) {
        if (condition) {
            this.geoParam = GeoParam.builder().field(fieldName).boost(boost).distanceStr(distance).centralGeoPoint(centralGeoPoint).isIn(isIn).build();
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, String fieldName, List<GeoPoint> geoPoints, Float boost, boolean isIn) {
        if (condition) {
            this.geoParam = GeoParam.builder().field(fieldName).boost(boost).geoPoints(geoPoints).isIn(isIn).build();
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, String fieldName, String indexedShapeId, Float boost, boolean isIn) {
        if (condition) {
            this.geoParam = GeoParam.builder().field(fieldName).boost(boost).indexedShapeId(indexedShapeId).isIn(isIn).build();
        }
        return this.typedThis;
    }

    private Children doIt(boolean condition, String fieldName, Geometry geometry, ShapeRelation shapeRelation, Float boost, boolean isIn) {
        if (condition) {
            this.geoParam = GeoParam.builder().field(fieldName).boost(boost).geometry(geometry).shapeRelation(shapeRelation).isIn(isIn).build();
        }
        return this.typedThis;
    }

    private void setModel(BaseEsParam baseEsParam, BaseEsParam.FieldValueModel model, EsAttachTypeEnum attachTypeEnum) {
        switch (attachTypeEnum) {
            case MUST: {
                baseEsParam.getMustList().add(model);
                break;
            }
            case FILTER: {
                baseEsParam.getFilterList().add(model);
                break;
            }
            case SHOULD: {
                baseEsParam.getShouldList().add(model);
                break;
            }
            case MUST_NOT: {
                baseEsParam.getMustNotList().add(model);
                break;
            }
            case GT: {
                baseEsParam.getGtList().add(model);
                break;
            }
            case LT: {
                baseEsParam.getLtList().add(model);
                break;
            }
            case GE: {
                baseEsParam.getGeList().add(model);
                break;
            }
            case LE: {
                baseEsParam.getLeList().add(model);
                break;
            }
            case IN: {
                baseEsParam.getInList().add(model);
                break;
            }
            case NOT_IN: {
                baseEsParam.getNotInList().add(model);
                break;
            }
            case EXISTS: {
                baseEsParam.getNotNullList().add(model);
                break;
            }
            case NOT_EXISTS: {
                baseEsParam.getIsNullList().add(model);
                break;
            }
            case BETWEEN: {
                baseEsParam.getBetweenList().add(model);
                break;
            }
            case NOT_BETWEEN: {
                baseEsParam.getNotBetweenList().add(model);
            }
            case LIKE_LEFT: {
                baseEsParam.getLikeLeftList().add(model);
                break;
            }
            case LIKE_RIGHT: {
                baseEsParam.getLikeRightList().add(model);
                break;
            }
            case MUST_MULTI_FIELDS: {
                baseEsParam.getMustMultiFieldList().add(model);
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u8fde\u63a5\u7c7b\u578b,\u8bf7\u53c2\u89c1EsAttachTypeEnum");
            }
        }
    }
}

