/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.toolkit;

import cn.easyes.annotation.HighLight;
import cn.easyes.annotation.TableField;
import cn.easyes.annotation.TableId;
import cn.easyes.annotation.TableName;
import cn.easyes.common.enums.FieldType;
import cn.easyes.common.enums.IdType;
import cn.easyes.common.params.DefaultNestedClass;
import cn.easyes.common.utils.ClassUtils;
import cn.easyes.common.utils.FastJsonUtils;
import cn.easyes.common.utils.ReflectionKit;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.EntityFieldInfo;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.biz.HighLightParam;
import cn.easyes.core.cache.BaseCache;
import cn.easyes.core.cache.GlobalConfigCache;
import cn.easyes.core.config.GlobalConfig;
import com.alibaba.fastjson.parser.deserializer.ExtraProcessor;
import com.alibaba.fastjson.serializer.NameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EntityInfoHelper {
    private static final Map<Class<?>, EntityInfo> ENTITY_INFO_CACHE = new ConcurrentHashMap();

    public static EntityInfo getEntityInfo(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        EntityInfo entityInfo = ENTITY_INFO_CACHE.get(ClassUtils.getUserClass(clazz));
        if (null != entityInfo) {
            return entityInfo;
        }
        for (Class<?> currentClass = clazz; null == entityInfo && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            entityInfo = ENTITY_INFO_CACHE.get(ClassUtils.getUserClass(currentClass));
        }
        if (entityInfo != null) {
            ENTITY_INFO_CACHE.put(ClassUtils.getUserClass(clazz), entityInfo);
        }
        GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
        return EntityInfoHelper.initTableInfo(globalConfig, clazz);
    }

    public static synchronized EntityInfo initTableInfo(GlobalConfig globalConfig, Class<?> clazz) {
        EntityInfo entityInfo = ENTITY_INFO_CACHE.get(clazz);
        if (entityInfo != null) {
            return entityInfo;
        }
        entityInfo = new EntityInfo();
        EntityInfoHelper.initTableName(clazz, globalConfig, entityInfo);
        EntityInfoHelper.initTableFields(clazz, globalConfig, entityInfo);
        ENTITY_INFO_CACHE.put(clazz, entityInfo);
        return entityInfo;
    }

    public static void initTableFields(Class<?> clazz, GlobalConfig globalConfig, EntityInfo entityInfo) {
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        List<Field> list = EntityInfoHelper.getAllFields(clazz);
        boolean isReadPK = false;
        boolean existTableId = EntityInfoHelper.isExistTableId(list);
        ArrayList<EntityFieldInfo> fieldList = new ArrayList<EntityFieldInfo>();
        for (Field field : list) {
            if (!isReadPK && (isReadPK = existTableId ? EntityInfoHelper.initTableIdWithAnnotation(dbConfig, entityInfo, field) : EntityInfoHelper.initTableIdWithoutAnnotation(dbConfig, entityInfo, field)) || EntityInfoHelper.initTableFieldWithAnnotation(dbConfig, fieldList, field, entityInfo)) continue;
            EntityInfoHelper.initTableFieldWithoutAnnotation(dbConfig, fieldList, field, entityInfo);
        }
        entityInfo.setFieldList(fieldList);
        EntityInfoHelper.addSimplePropertyPreFilter(entityInfo, clazz);
        EntityInfoHelper.addExtraProcessor(entityInfo);
    }

    private static void addSimplePropertyPreFilter(EntityInfo entityInfo, Class<?> clazz) {
        ArrayList<SerializeFilter> preFilters = new ArrayList<SerializeFilter>();
        SimplePropertyPreFilter entityClassPreFilter = FastJsonUtils.getSimplePropertyPreFilter(clazz, entityInfo.getNotSerializeField());
        Optional.ofNullable(entityClassPreFilter).ifPresent(preFilters::add);
        entityInfo.getNestedNotSerializeField().forEach((k, v) -> Optional.ofNullable(FastJsonUtils.getSimplePropertyPreFilter((Class)k, (Set)v)).ifPresent(preFilters::add));
        if (!entityInfo.isChild()) {
            HashSet<String> notSerialField = new HashSet<String>();
            notSerialField.add("parent");
            Optional.ofNullable(FastJsonUtils.getSimplePropertyPreFilter(entityInfo.getJoinFieldClass(), notSerialField)).ifPresent(preFilters::add);
        }
        EntityInfoHelper.addNameFilter(entityInfo, preFilters);
        entityInfo.getClassSimplePropertyPreFilterMap().putIfAbsent(clazz, preFilters);
        entityInfo.getNotSerializeField().clear();
        entityInfo.getNestedNotSerializeField().clear();
    }

    private static void addExtraProcessor(EntityInfo entityInfo) {
        Map<String, String> columnMappingMap = entityInfo.getColumnMappingMap();
        Map<Class<?>, Map<String, String>> nestedClassColumnMappingMap = entityInfo.getNestedClassColumnMappingMap();
        ExtraProcessor extraProcessor = (object, key, value) -> {
            Map nestedColumnMappingMap = (Map)nestedClassColumnMappingMap.get(object.getClass());
            if (nestedColumnMappingMap != null) {
                EntityInfoHelper.invokeExtraProcessor(nestedColumnMappingMap, object, key, value, object.getClass());
            } else {
                EntityInfoHelper.invokeExtraProcessor(columnMappingMap, object, key, value, object.getClass());
            }
        };
        entityInfo.setExtraProcessor(extraProcessor);
    }

    private static void invokeExtraProcessor(Map<String, String> columnMappingMap, Object object, String key, Object value, Class<?> clazz) {
        Optional.ofNullable(columnMappingMap.get(key)).flatMap(realMethodName -> Optional.ofNullable(BaseCache.setterMethod(clazz, realMethodName))).ifPresent(method -> {
            try {
                method.invoke(object, value);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
    }

    private static void addNameFilter(EntityInfo entityInfo, List<SerializeFilter> preFilters) {
        Map<String, String> mappingColumnMap = entityInfo.getMappingColumnMap();
        Map<Class<?>, Map<String, String>> nestedClassMappingColumnMap = entityInfo.getNestedClassMappingColumnMap();
        if (!mappingColumnMap.isEmpty()) {
            NameFilter nameFilter = (object, name, value) -> {
                Map nestedMappingColumnMap = (Map)nestedClassMappingColumnMap.get(object.getClass());
                if (Objects.nonNull(nestedMappingColumnMap)) {
                    String nestedMappingColumn = (String)nestedMappingColumnMap.get(name);
                    if (Objects.equals(nestedMappingColumn, name)) {
                        return name;
                    }
                    return nestedMappingColumn;
                }
                String mappingColumn = (String)mappingColumnMap.get(name);
                if (Objects.equals(mappingColumn, name)) {
                    return name;
                }
                return mappingColumn;
            };
            preFilters.add((SerializeFilter)nameFilter);
        }
    }

    private static boolean initTableFieldWithAnnotation(GlobalConfig.DbConfig dbConfig, List<EntityFieldInfo> fieldList, Field field, EntityInfo entityInfo) {
        boolean hasAnnotation = false;
        if (field.isAnnotationPresent(TableField.class)) {
            EntityInfoHelper.initTableFieldAnnotation(dbConfig, entityInfo, field, fieldList);
            hasAnnotation = true;
        }
        if (field.isAnnotationPresent(HighLight.class)) {
            EntityInfoHelper.initHighLightAnnotation(dbConfig, entityInfo, field);
            hasAnnotation = true;
        }
        return hasAnnotation;
    }

    private static void initTableFieldAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field, List<EntityFieldInfo> fieldList) {
        TableField tableField = field.getAnnotation(TableField.class);
        if (tableField.exist()) {
            String mappingColumn;
            EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, field, tableField);
            if (!StringUtils.isBlank((CharSequence)tableField.value().trim())) {
                entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), tableField.value());
                entityInfo.getColumnMappingMap().putIfAbsent(tableField.value(), field.getName());
                mappingColumn = tableField.value();
            } else {
                mappingColumn = EntityInfoHelper.initMappingColumnMapAndGet(dbConfig, entityInfo, field);
            }
            if (StringUtils.isNotBlank((CharSequence)tableField.dateFormat())) {
                entityFieldInfo.setDateFormat(tableField.dateFormat());
            }
            entityFieldInfo.setMappingColumn(mappingColumn);
            entityFieldInfo.setAnalyzer(tableField.analyzer());
            entityFieldInfo.setSearchAnalyzer(tableField.searchAnalyzer());
            entityFieldInfo.setFieldType(tableField.fieldType());
            entityFieldInfo.setColumnType(field.getType().getSimpleName());
            if (FieldType.JOIN.equals((Object)tableField.fieldType())) {
                entityFieldInfo.setParentName(tableField.parentName());
                entityFieldInfo.setChildName(tableField.childName());
                entityInfo.setJoinFieldName(mappingColumn);
                entityInfo.setJoinFieldClass(tableField.joinFieldClass());
                entityInfo.getPathClassMap().putIfAbsent(field.getName(), tableField.joinFieldClass());
                EntityInfoHelper.processNested(tableField.joinFieldClass(), dbConfig, entityInfo);
            }
            fieldList.add(entityFieldInfo);
            if (DefaultNestedClass.class != tableField.nestedClass()) {
                entityInfo.getPathClassMap().putIfAbsent(field.getName(), tableField.nestedClass());
                EntityInfoHelper.processNested(tableField.nestedClass(), dbConfig, entityInfo);
            }
        } else {
            entityInfo.getNotSerializeField().add(field.getName());
        }
    }

    private static void initHighLightAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String realHighLightField;
        HighLight highLight = field.getAnnotation(HighLight.class);
        String mappingField = highLight.mappingField();
        if (StringUtils.isNotBlank((CharSequence)mappingField)) {
            entityInfo.getNotSerializeField().add(mappingField);
        } else {
            mappingField = field.getName();
        }
        String customField = entityInfo.getMappingColumnMap().get(field.getName());
        String string = realHighLightField = Objects.isNull(customField) ? field.getName() : customField;
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            realHighLightField = StringUtils.camelToUnderline((String)realHighLightField);
        }
        entityInfo.getHighlightFieldMap().putIfAbsent(realHighLightField, mappingField);
        HighLightParam highLightParam = new HighLightParam(highLight.preTag(), highLight.postTag(), realHighLightField);
        entityInfo.getHighLightParams().add(highLightParam);
    }

    private static void processNested(Class<?> nestedClass, GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo) {
        List<Field> allFields = EntityInfoHelper.getAllFields(nestedClass);
        HashMap mappingColumnMap = new HashMap(allFields.size());
        HashMap columnMappingMap = new HashMap(allFields.size());
        ArrayList entityFieldInfoList = new ArrayList();
        HashSet notSerializedFields = new HashSet();
        allFields.forEach(field -> {
            String mappingColumn;
            TableField tableField = field.getAnnotation(TableField.class);
            if (Objects.isNull(tableField)) {
                mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
                EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, (Field)field);
                entityFieldInfo.setMappingColumn(mappingColumn);
                entityFieldInfo.setFieldType(FieldType.TEXT);
                entityFieldInfo.setColumnType(FieldType.TEXT.getType());
                entityFieldInfoList.add(entityFieldInfo);
            } else if (tableField.exist()) {
                if (DefaultNestedClass.class != tableField.nestedClass()) {
                    entityInfo.getPathClassMap().putIfAbsent(field.getName(), tableField.nestedClass());
                    EntityInfoHelper.processNested(tableField.nestedClass(), dbConfig, entityInfo);
                }
                mappingColumn = StringUtils.isNotBlank((CharSequence)tableField.value().trim()) ? tableField.value() : EntityInfoHelper.getMappingColumn(dbConfig, field);
                EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, (Field)field, tableField);
                entityFieldInfo.setMappingColumn(mappingColumn);
                FieldType fieldType = FieldType.NESTED.equals((Object)tableField.fieldType()) ? FieldType.NESTED : FieldType.TEXT;
                entityFieldInfo.setFieldType(fieldType);
                entityFieldInfo.setColumnType(fieldType.getType());
                entityFieldInfo.setAnalyzer(tableField.analyzer());
                entityFieldInfo.setSearchAnalyzer(tableField.searchAnalyzer());
                entityFieldInfoList.add(entityFieldInfo);
            } else {
                mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
                notSerializedFields.add(field.getName());
            }
            columnMappingMap.putIfAbsent(mappingColumn, field.getName());
            mappingColumnMap.putIfAbsent(field.getName(), mappingColumn);
        });
        entityInfo.getNestedNotSerializeField().putIfAbsent(nestedClass, notSerializedFields);
        entityInfo.getNestedClassColumnMappingMap().putIfAbsent(nestedClass, columnMappingMap);
        entityInfo.getNestedClassMappingColumnMap().putIfAbsent(nestedClass, mappingColumnMap);
        entityInfo.getNestedFieldListMap().put(nestedClass, entityFieldInfoList);
    }

    private static void initTableFieldWithoutAnnotation(GlobalConfig.DbConfig dbConfig, List<EntityFieldInfo> fieldList, Field field, EntityInfo entityInfo) {
        boolean isNotSerializedField = entityInfo.getNotSerializeField().contains(field.getName());
        if (isNotSerializedField) {
            return;
        }
        EntityFieldInfo entityFieldInfo = new EntityFieldInfo(dbConfig, field);
        String mappingColumn = EntityInfoHelper.initMappingColumnMapAndGet(dbConfig, entityInfo, field);
        entityFieldInfo.setMappingColumn(mappingColumn);
        entityFieldInfo.setColumnType(field.getType().getSimpleName());
        fieldList.add(entityFieldInfo);
    }

    private static boolean initTableIdWithAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        TableId tableId = field.getAnnotation(TableId.class);
        if (tableId != null) {
            if (IdType.NONE == tableId.type()) {
                entityInfo.setIdType(dbConfig.getIdType());
            } else {
                entityInfo.setIdType(tableId.type());
            }
            field.setAccessible(Boolean.TRUE);
            entityInfo.setClazz(field.getDeclaringClass()).setKeyField(field).setIdClass(field.getType()).setKeyProperty(field.getName());
            entityInfo.getNotSerializeField().add("id");
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), "id");
            return true;
        }
        return false;
    }

    private static boolean initTableIdWithoutAnnotation(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String column = field.getName();
        if ("id".equalsIgnoreCase(column) || "_id".equals(column)) {
            field.setAccessible(Boolean.TRUE);
            entityInfo.setIdType(dbConfig.getIdType()).setKeyProperty(field.getName()).setKeyField(field).setIdClass(field.getType()).setClazz(field.getDeclaringClass());
            entityInfo.getNotSerializeField().add("id");
            entityInfo.getNotSerializeField().add(field.getName());
            entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), "id");
            return true;
        }
        return false;
    }

    public static boolean isExistTableId(List<Field> list) {
        for (Field field : list) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId == null) continue;
            return true;
        }
        return false;
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        return ReflectionKit.getFieldList((Class)ClassUtils.getUserClass(clazz));
    }

    private static void initTableName(Class<?> clazz, GlobalConfig globalConfig, EntityInfo entityInfo) {
        String indexName;
        GlobalConfig.DbConfig dbConfig = globalConfig.getDbConfig();
        TableName table = clazz.getAnnotation(TableName.class);
        String tableName = clazz.getSimpleName().toLowerCase(Locale.ROOT);
        String tablePrefix = dbConfig.getTablePrefix();
        boolean tablePrefixEffect = true;
        if (Objects.isNull(table)) {
            indexName = tableName;
        } else {
            if (StringUtils.isNotBlank((CharSequence)table.value())) {
                indexName = table.value();
                if (StringUtils.isNotBlank((CharSequence)tablePrefix) && !table.keepGlobalPrefix()) {
                    tablePrefixEffect = false;
                }
            } else {
                indexName = tableName;
            }
            entityInfo.setAliasName(table.aliasName());
            entityInfo.setShardsNum(table.shardsNum());
            entityInfo.setReplicasNum(table.replicasNum());
            entityInfo.setChild(table.child());
            entityInfo.setChildClass(table.childClass());
        }
        String targetIndexName = indexName;
        if (StringUtils.isNotBlank((CharSequence)tablePrefix) && tablePrefixEffect) {
            targetIndexName = tablePrefix + targetIndexName;
        }
        entityInfo.setIndexName(targetIndexName);
    }

    private static String initMappingColumnMapAndGet(GlobalConfig.DbConfig dbConfig, EntityInfo entityInfo, Field field) {
        String mappingColumn = EntityInfoHelper.getMappingColumn(dbConfig, field);
        entityInfo.getMappingColumnMap().putIfAbsent(field.getName(), mappingColumn);
        return mappingColumn;
    }

    private static String getMappingColumn(GlobalConfig.DbConfig dbConfig, Field field) {
        String mappingColumn = field.getName();
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            mappingColumn = StringUtils.camelToUnderline((String)field.getName());
        }
        return mappingColumn;
    }
}

