/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.toolkit;

import cn.easyes.common.params.SFunction;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.cache.GlobalConfigCache;
import cn.easyes.core.config.GlobalConfig;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class FieldUtils {
    public static <R> String getFieldName(R func) {
        String fieldName = FieldUtils.getFieldNameNotConvertId(func);
        if ("id".equals(fieldName)) {
            fieldName = "_id";
        }
        return fieldName;
    }

    public static <R> String getFieldNameNotConvertId(R func) {
        if (!(func instanceof SFunction)) {
            throw new RuntimeException("not support this type of column");
        }
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(func, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            return FieldUtils.resolveFieldName(getter);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String val(SFunction<T, ?> func) {
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(func, new Object[0]);
            String getter = serializedLambda.getImplMethodName();
            return FieldUtils.resolveFieldName(getter);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            throw new RuntimeException("no get method found!");
        }
    }

    public static String resolveFieldName(String getMethodName) {
        if (getMethodName.startsWith("get")) {
            getMethodName = getMethodName.substring(3);
        } else if (getMethodName.startsWith("Is")) {
            getMethodName = getMethodName.substring(2);
        }
        return FieldUtils.firstToLowerCase(getMethodName);
    }

    public static String generateGetFunctionName(String fieldName) {
        return "get" + FieldUtils.firstToUpperCase(fieldName);
    }

    public static String generateSetFunctionName(String fieldName) {
        return "set" + FieldUtils.firstToUpperCase(fieldName);
    }

    private static String firstToLowerCase(String param) {
        if (Objects.isNull(param) || "".equals(param)) {
            return "";
        }
        return param.substring(0, 1).toLowerCase() + param.substring(1);
    }

    public static String firstToUpperCase(String param) {
        if (Objects.isNull(param) || "".equals(param)) {
            return "";
        }
        return param.substring(0, 1).toUpperCase() + param.substring(1);
    }

    public static String getRealField(String field, Map<String, String> mappingColumnMap, GlobalConfig.DbConfig dbConfig) {
        String customField = mappingColumnMap.get(field);
        if (Objects.nonNull(customField)) {
            return "id".equals(customField) ? "_id" : customField;
        }
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            return StringUtils.camelToUnderline((String)field);
        }
        return field;
    }

    public static String getRealFieldNotConvertId(String field, Map<String, String> mappingColumnMap, GlobalConfig.DbConfig dbConfig) {
        String customField = mappingColumnMap.get(field);
        if (Objects.nonNull(customField)) {
            return customField;
        }
        if (dbConfig.isMapUnderscoreToCamelCase()) {
            return StringUtils.camelToUnderline((String)field);
        }
        return field;
    }

    public static String[] getRealFields(String[] fields, Map<String, String> mappingColumnMap, GlobalConfig.DbConfig dbConfig) {
        return Arrays.stream(fields).map(field -> FieldUtils.getRealField(field, mappingColumnMap, dbConfig)).collect(Collectors.toList()).toArray(new String[0]);
    }

    public static List<String> getRealFields(List<String> fields, Map<String, String> mappingColumnMap) {
        return Arrays.stream(FieldUtils.getRealFields(fields.toArray(new String[0]), mappingColumnMap, GlobalConfigCache.getGlobalConfig().getDbConfig())).collect(Collectors.toList());
    }

    private FieldUtils() {
    }
}

