/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.toolkit;

import cn.easyes.common.constants.BaseEsConstants;
import cn.easyes.common.enums.FieldType;
import cn.easyes.common.enums.JdkDataTypeEnum;
import cn.easyes.common.params.DefaultChildClass;
import cn.easyes.common.utils.CollectionUtils;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.common.utils.LogUtils;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.CreateIndexParam;
import cn.easyes.core.biz.EntityFieldInfo;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.biz.EsIndexInfo;
import cn.easyes.core.biz.EsIndexParam;
import cn.easyes.core.cache.GlobalConfigCache;
import cn.easyes.core.config.GlobalConfig;
import cn.easyes.core.toolkit.EntityInfoHelper;
import cn.easyes.core.toolkit.LockUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.ReindexRequest;

public class IndexUtils {
    private static final String FIELDS_KEY;
    private static final Map<String, Object> FIELDS_MAP;
    private static final int IGNORE_ABOVE;
    private static final String IGNORE_ABOVE_KEY;

    public static boolean existsIndex(RestHighLevelClient client, String indexName) {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        try {
            return client.indices().exists(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"existsIndex exception indexName: %s", (Throwable)e, (Object[])new Object[]{indexName});
        }
    }

    public static boolean createIndex(RestHighLevelClient client, EntityInfo entityInfo, CreateIndexParam indexParam) {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexParam.getIndexName());
        if (Objects.isNull(indexParam.getSettings())) {
            Settings.Builder settings = Settings.builder();
            Optional.ofNullable(indexParam.getShardsNum()).ifPresent(shards -> settings.put("index.number_of_shards", shards.intValue()));
            Optional.ofNullable(indexParam.getReplicasNum()).ifPresent(replicas -> settings.put("index.number_of_replicas", replicas.intValue()));
            createIndexRequest.settings(settings);
        } else {
            createIndexRequest.settings(indexParam.getSettings());
        }
        if (Objects.isNull(indexParam.getMapping())) {
            Map<String, Object> mapping = IndexUtils.initMapping(entityInfo, indexParam.getEsIndexParamList());
            createIndexRequest.mapping(mapping);
        } else {
            createIndexRequest.mapping(indexParam.getMapping());
        }
        Optional.ofNullable(indexParam.getAliasName()).ifPresent(aliasName -> {
            Alias alias = new Alias(aliasName);
            createIndexRequest.alias(alias);
        });
        try {
            CreateIndexResponse createIndexResponse = client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
            return createIndexResponse.isAcknowledged();
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"create index exception createIndexRequest: %s ", (Throwable)e, (Object[])new Object[]{createIndexRequest.toString()});
        }
    }

    public static boolean createEmptyIndex(RestHighLevelClient client, String indexName) {
        CreateIndexResponse createIndexResponse;
        CreateIndexRequest request = new CreateIndexRequest(indexName);
        try {
            createIndexResponse = client.indices().create(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LogUtils.info((String[])new String[]{"===> distribute lock index has created"});
            return Boolean.TRUE;
        }
        return createIndexResponse.isAcknowledged();
    }

    public static EsIndexInfo getIndexInfo(RestHighLevelClient client, String indexName) {
        GetIndexResponse getIndexResponse = IndexUtils.getIndex(client, indexName);
        return IndexUtils.parseGetIndexResponse(getIndexResponse, indexName);
    }

    public static GetIndexResponse getIndex(RestHighLevelClient client, String indexName) {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        try {
            return client.indices().get(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"getIndex exception indexName: %s", (Throwable)e, (Object[])new Object[]{indexName});
        }
    }

    public static void addDefaultAlias(RestHighLevelClient client, String indexName) {
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasActions = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD);
        aliasActions.index(indexName);
        aliasActions.alias("ee_default_alias");
        indicesAliasesRequest.addAliasAction(aliasActions);
        try {
            client.indices().updateAliases(indicesAliasesRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LogUtils.warn((String[])new String[]{"addDefaultAlias exception", e.toString()});
        }
    }

    public static boolean reindex(RestHighLevelClient client, String oldIndexName, String releaseIndexName) {
        ReindexRequest reindexRequest = new ReindexRequest();
        reindexRequest.setSourceIndices(new String[]{oldIndexName});
        reindexRequest.setDestIndex(releaseIndexName);
        reindexRequest.setDestOpType("create");
        reindexRequest.setConflicts("proceed");
        reindexRequest.setRefresh(Boolean.TRUE.booleanValue());
        try {
            BulkByScrollResponse response = client.reindex(reindexRequest, RequestOptions.DEFAULT);
            List bulkFailures = response.getBulkFailures();
            if (CollectionUtils.isEmpty((Collection)bulkFailures)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"reindex exception oldIndexName:%s, releaseIndexName: %s", (Throwable)e, (Object[])new Object[]{oldIndexName, releaseIndexName});
        }
    }

    public static EsIndexInfo parseGetIndexResponse(GetIndexResponse getIndexResponse, String indexName) {
        EsIndexInfo esIndexInfo = new EsIndexInfo();
        esIndexInfo.setHasDefaultAlias(Boolean.FALSE);
        Optional.ofNullable(getIndexResponse.getAliases()).flatMap(aliases -> Optional.ofNullable(aliases.get(indexName))).ifPresent(aliasMetadataList -> aliasMetadataList.forEach(aliasMetadata -> {
            if ("ee_default_alias".equals(aliasMetadata.alias())) {
                esIndexInfo.setHasDefaultAlias(Boolean.TRUE);
            }
        }));
        Optional.ofNullable(getIndexResponse.getSettings()).flatMap(settingsMap -> Optional.ofNullable(settingsMap.get(indexName))).ifPresent(p -> {
            String shardsNumStr = p.get("index.number_of_shards");
            Optional.ofNullable(shardsNumStr).ifPresent(s -> esIndexInfo.setShardsNum(Integer.parseInt(s)));
            String replicasNumStr = p.get("index.number_of_replicas");
            Optional.ofNullable(replicasNumStr).ifPresent(r -> esIndexInfo.setReplicasNum(Integer.parseInt(r)));
        });
        Optional.ofNullable(getIndexResponse.getMappings()).flatMap(stringMappingMetadataMap -> Optional.ofNullable(stringMappingMetadataMap.get(indexName)).flatMap(mappingMetadata -> Optional.ofNullable(mappingMetadata.getSourceAsMap()))).ifPresent(esIndexInfo::setMapping);
        return esIndexInfo;
    }

    public static String getEsFieldType(FieldType fieldType, String typeName) {
        String type;
        if (Objects.nonNull(fieldType) && !FieldType.NONE.equals((Object)fieldType)) {
            return fieldType.getType();
        }
        JdkDataTypeEnum jdkDataType = JdkDataTypeEnum.getByType((String)typeName.toLowerCase());
        switch (jdkDataType) {
            case BYTE: {
                type = FieldType.BYTE.getType();
                break;
            }
            case SHORT: {
                type = FieldType.SHORT.getType();
                break;
            }
            case INT: 
            case INTEGER: {
                type = FieldType.INTEGER.getType();
                break;
            }
            case LONG: {
                type = FieldType.LONG.getType();
                break;
            }
            case FLOAT: {
                type = FieldType.FLOAT.getType();
                break;
            }
            case DOUBLE: {
                type = FieldType.DOUBLE.getType();
                break;
            }
            case BIG_DECIMAL: 
            case STRING: 
            case CHAR: {
                type = FieldType.KEYWORD.getType();
                break;
            }
            case BOOLEAN: {
                type = FieldType.BOOLEAN.getType();
                break;
            }
            case DATE: 
            case LOCAL_DATE: 
            case LOCAL_DATE_TIME: {
                type = FieldType.DATE.getType();
                break;
            }
            case LIST: {
                type = FieldType.TEXT.getType();
                break;
            }
            default: {
                return FieldType.KEYWORD.getType();
            }
        }
        return type;
    }

    public static Map<String, Object> initMapping(EntityInfo entityInfo, List<EsIndexParam> indexParamList) {
        HashMap<String, Object> mapping = new HashMap<String, Object>(1);
        if (CollectionUtils.isEmpty(indexParamList)) {
            return mapping;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(indexParamList.size());
        GlobalConfig.DbConfig dbConfig = Optional.ofNullable(GlobalConfigCache.getGlobalConfig()).map(GlobalConfig::getDbConfig).orElse(new GlobalConfig.DbConfig());
        IndexUtils.initInfo(entityInfo, dbConfig, properties, indexParamList);
        mapping.put("properties", properties);
        return mapping;
    }

    private static Map<String, Object> initInfo(EntityInfo entityInfo, GlobalConfig.DbConfig dbConfig, Map<String, Object> properties, List<EsIndexParam> indexParamList) {
        indexParamList.forEach(indexParam -> {
            HashMap<String, Object> info = new HashMap<String, Object>();
            Optional.ofNullable(indexParam.getDateFormat()).ifPresent(format -> info.put("format", indexParam.getDateFormat()));
            if (FieldType.KEYWORD_TEXT.getType().equals(indexParam.getFieldType())) {
                info.put("type", FieldType.TEXT.getType());
                info.put(FIELDS_KEY, FIELDS_MAP);
            } else {
                info.put("type", indexParam.getFieldType());
            }
            if (FieldType.TEXT.getType().equals(indexParam.getFieldType())) {
                Optional.ofNullable(indexParam.getAnalyzer()).ifPresent(analyzer -> info.put("analyzer", indexParam.getAnalyzer().toLowerCase()));
                Optional.ofNullable(indexParam.getSearchAnalyzer()).ifPresent(searchAnalyzer -> info.put("search_analyzer", indexParam.getSearchAnalyzer().toLowerCase()));
            }
            Optional.ofNullable(indexParam.getBoost()).ifPresent(boost -> info.put("boost", indexParam.getBoost()));
            if (FieldType.JOIN.getType().equals(indexParam.getFieldType())) {
                HashMap<String, String> relation = new HashMap<String, String>(1);
                relation.put(indexParam.getParentName(), indexParam.getChildName());
                info.put("eager_global_ordinals", Boolean.TRUE);
                info.put("relations", relation);
            }
            if (FieldType.NESTED.getType().equals(indexParam.getFieldType())) {
                List<EntityFieldInfo> nestedFields = entityInfo.getNestedFieldListMap().get(indexParam.getNestedClass());
                List<EsIndexParam> esIndexParams = IndexUtils.initIndexParam(entityInfo, nestedFields, true);
                Map<String, Object> nested = IndexUtils.initInfo(entityInfo, dbConfig, new HashMap<String, Object>(), esIndexParams);
                info.put("properties", nested);
            }
            String fieldName = indexParam.getFieldName();
            if (dbConfig.isMapUnderscoreToCamelCase()) {
                fieldName = StringUtils.camelToUnderline((String)fieldName);
            }
            properties.put(fieldName, info);
        });
        return properties;
    }

    public static boolean changeAliasAtomic(RestHighLevelClient client, String oldIndexName, String releaseIndexName) {
        IndicesAliasesRequest.AliasActions addIndexAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(releaseIndexName).alias("ee_default_alias");
        IndicesAliasesRequest.AliasActions removeAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(oldIndexName).alias("ee_default_alias");
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest();
        indicesAliasesRequest.addAliasAction(addIndexAction);
        indicesAliasesRequest.addAliasAction(removeAction);
        try {
            AcknowledgedResponse acknowledgedResponse = client.indices().updateAliases(indicesAliasesRequest, RequestOptions.DEFAULT);
            return acknowledgedResponse.isAcknowledged();
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"changeAlias exception oldIndexName: %s, releaseIndexName: %s", (Throwable)e, (Object[])new Object[]{oldIndexName, releaseIndexName});
        }
    }

    public static boolean deleteIndex(RestHighLevelClient client, String indexName) {
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
        deleteIndexRequest.indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        try {
            AcknowledgedResponse acknowledgedResponse = client.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT);
            return acknowledgedResponse.isAcknowledged();
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"deleteIndex exception indexName: %s", (Throwable)e, (Object[])new Object[]{indexName});
        }
    }

    public static CreateIndexParam getCreateIndexParam(EntityInfo entityInfo) {
        List<EsIndexParam> esIndexParamList = IndexUtils.initIndexParam(entityInfo, entityInfo.getFieldList(), false);
        CreateIndexParam createIndexParam = new CreateIndexParam();
        createIndexParam.setEsIndexParamList(esIndexParamList);
        createIndexParam.setAliasName(entityInfo.getAliasName());
        createIndexParam.setShardsNum(entityInfo.getShardsNum());
        createIndexParam.setReplicasNum(entityInfo.getReplicasNum());
        createIndexParam.setIndexName(entityInfo.getIndexName());
        Optional.ofNullable(entityInfo.getReleaseIndexName()).ifPresent(createIndexParam::setIndexName);
        return createIndexParam;
    }

    public static List<EsIndexParam> initIndexParam(EntityInfo entityInfo, List<EntityFieldInfo> fieldList, boolean isNested) {
        EntityInfo childEntityInfo;
        List<EntityFieldInfo> childFieldList;
        boolean addChild;
        ArrayList<EntityFieldInfo> copyFieldList = new ArrayList<EntityFieldInfo>();
        copyFieldList.addAll(fieldList);
        boolean bl = addChild = !DefaultChildClass.class.equals(entityInfo.getChildClass()) && !isNested;
        if (addChild && !CollectionUtils.isEmpty(childFieldList = (childEntityInfo = EntityInfoHelper.getEntityInfo(entityInfo.getChildClass())).getFieldList())) {
            childFieldList.forEach(child -> {
                if (FieldType.KEYWORD.equals((Object)child.getFieldType())) {
                    child.setFieldType(FieldType.TEXT);
                }
                if (!entityInfo.getJoinFieldName().equals(child.getMappingColumn())) {
                    copyFieldList.add((EntityFieldInfo)child);
                }
            });
        }
        ArrayList<EsIndexParam> esIndexParamList = new ArrayList<EsIndexParam>();
        if (CollectionUtils.isNotEmpty(copyFieldList)) {
            copyFieldList.forEach(field -> {
                EsIndexParam esIndexParam = new EsIndexParam();
                String esFieldType = IndexUtils.getEsFieldType(field.getFieldType(), field.getColumnType());
                esIndexParam.setFieldType(esFieldType);
                esIndexParam.setFieldName(field.getMappingColumn());
                esIndexParam.setDateFormat(field.getDateFormat());
                if (FieldType.NESTED.equals((Object)field.getFieldType())) {
                    esIndexParam.setNestedClass(entityInfo.getPathClassMap().get(field.getColumn()));
                }
                if (!"none".equals(field.getAnalyzer())) {
                    esIndexParam.setAnalyzer(field.getAnalyzer());
                }
                if (!"none".equals(field.getSearchAnalyzer()) && !Objects.equals(field.getAnalyzer(), field.getSearchAnalyzer())) {
                    esIndexParam.setSearchAnalyzer(field.getSearchAnalyzer());
                }
                Optional.ofNullable(field.getParentName()).ifPresent(esIndexParam::setParentName);
                Optional.ofNullable(field.getChildName()).ifPresent(esIndexParam::setChildName);
                esIndexParamList.add(esIndexParam);
            });
        }
        return esIndexParamList;
    }

    public static boolean isIndexNeedChange(EsIndexInfo esIndexInfo, EntityInfo entityInfo) {
        if (!entityInfo.getShardsNum().equals(esIndexInfo.getShardsNum())) {
            return Boolean.TRUE;
        }
        if (!entityInfo.getReplicasNum().equals(esIndexInfo.getReplicasNum())) {
            return Boolean.TRUE;
        }
        List<EsIndexParam> esIndexParamList = IndexUtils.initIndexParam(entityInfo, entityInfo.getFieldList(), false);
        Map<String, Object> mapping = IndexUtils.initMapping(entityInfo, esIndexParamList);
        return !mapping.equals(esIndexInfo.getMapping());
    }

    public static boolean existsIndexWithRetryAndSetActiveIndex(EntityInfo entityInfo, RestHighLevelClient client) {
        boolean exists = IndexUtils.existsIndexWithRetry(entityInfo, client);
        Optional.ofNullable(entityInfo.getRetrySuccessIndexName()).ifPresent(entityInfo::setIndexName);
        return exists;
    }

    public static boolean existsIndexWithRetry(EntityInfo entityInfo, RestHighLevelClient client) {
        boolean exists = IndexUtils.existsIndex(client, entityInfo.getIndexName());
        if (exists) {
            entityInfo.setRetrySuccessIndexName(entityInfo.getIndexName());
            return true;
        }
        for (int i = 0; i <= 1; ++i) {
            String retryIndexName = entityInfo.getIndexName() + "_s" + i;
            exists = IndexUtils.existsIndex(client, retryIndexName);
            if (!exists) continue;
            entityInfo.setRetrySuccessIndexName(retryIndexName);
            break;
        }
        return exists;
    }

    public static void supplyAsync(BiFunction<Class<?>, RestHighLevelClient, Boolean> biFunction, Class<?> entityClass, RestHighLevelClient client) {
        CompletionStage completableFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
            if (!globalConfig.isDistributed()) {
                return (Boolean)biFunction.apply(entityClass, client);
            }
            try {
                boolean lock = LockUtils.tryLock(client, entityClass.getSimpleName().toLowerCase(), BaseEsConstants.LOCK_MAX_RETRY);
                if (!lock) {
                    LogUtils.warn((String[])new String[]{"retry get distribute lock failed, please check whether other resources have been preempted or deadlocked"});
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                Boolean bl = (Boolean)biFunction.apply(entityClass, client);
                return bl;
            }
            finally {
                LockUtils.release(client, entityClass.getSimpleName().toLowerCase(), BaseEsConstants.LOCK_MAX_RETRY);
            }
        }).exceptionally(throwable -> {
            Optional.ofNullable(throwable).ifPresent(e -> LogUtils.error((String[])new String[]{"process index exception", e.toString()}));
            IndexUtils.deleteIndex(client, EntityInfoHelper.getEntityInfo(entityClass).getReleaseIndexName());
            IndexUtils.deleteIndex(client, "ee-distribute-lock");
            return Boolean.FALSE;
        })).whenCompleteAsync((success, throwable) -> {
            if (success.booleanValue()) {
                LogUtils.info((String[])new String[]{"===> Congratulations auto process index by Easy-Es is done !"});
            } else {
                LogUtils.warn((String[])new String[]{"===> Unfortunately, auto process index by Easy-Es failed, please check your configuration"});
                IndexUtils.deleteIndex(client, EntityInfoHelper.getEntityInfo(entityClass).getReleaseIndexName());
                IndexUtils.deleteIndex(client, "ee-distribute-lock");
            }
        });
        GlobalConfig globalConfig = GlobalConfigCache.getGlobalConfig();
        if (globalConfig.isAsyncProcessIndexBlocking()) {
            ((CompletableFuture)completableFuture).join();
        }
    }

    private IndexUtils() {
    }

    static {
        FIELDS_MAP = new HashMap<String, Object>();
        FIELDS_KEY = "fields";
        IGNORE_ABOVE = 256;
        IGNORE_ABOVE_KEY = "ignore_above";
        HashMap<String, Object> keywordsMap = new HashMap<String, Object>();
        keywordsMap.put("type", FieldType.KEYWORD.getType());
        keywordsMap.put(IGNORE_ABOVE_KEY, IGNORE_ABOVE);
        FIELDS_MAP.put(FieldType.KEYWORD.getType(), keywordsMap);
    }
}

