/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.conditions;

import cn.easyes.common.constants.BaseEsConstants;
import cn.easyes.common.enums.FieldStrategy;
import cn.easyes.common.enums.IdType;
import cn.easyes.common.utils.ArrayUtils;
import cn.easyes.common.utils.Assert;
import cn.easyes.common.utils.CollectionUtils;
import cn.easyes.common.utils.ExceptionUtils;
import cn.easyes.common.utils.FastJsonUtils;
import cn.easyes.common.utils.LogUtils;
import cn.easyes.common.utils.ReflectionKit;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.CreateIndexParam;
import cn.easyes.core.biz.EntityFieldInfo;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.biz.EsIndexParam;
import cn.easyes.core.biz.EsUpdateParam;
import cn.easyes.core.biz.PageInfo;
import cn.easyes.core.cache.BaseCache;
import cn.easyes.core.cache.GlobalConfigCache;
import cn.easyes.core.conditions.LambdaEsIndexWrapper;
import cn.easyes.core.conditions.LambdaEsQueryWrapper;
import cn.easyes.core.conditions.LambdaEsUpdateWrapper;
import cn.easyes.core.conditions.WrapperProcessor;
import cn.easyes.core.conditions.interfaces.BaseEsMapper;
import cn.easyes.core.toolkit.EntityInfoHelper;
import cn.easyes.core.toolkit.FieldUtils;
import cn.easyes.core.toolkit.IndexUtils;
import cn.easyes.core.toolkit.PageHelper;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.metrics.ParsedCardinality;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class BaseEsMapperImpl<T>
implements BaseEsMapper<T> {
    private RestHighLevelClient client;
    private Class<T> entityClass;

    @Override
    public Boolean existsIndex(String indexName) {
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw ExceptionUtils.eee((String)"indexName can not be empty", (Object[])new Object[0]);
        }
        return IndexUtils.existsIndex(this.client, indexName);
    }

    @Override
    public GetIndexResponse getIndex() {
        return IndexUtils.getIndex(this.client, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public GetIndexResponse getIndex(String indexName) {
        return IndexUtils.getIndex(this.client, this.getIndexName(indexName));
    }

    @Override
    public Boolean createIndex() {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        CreateIndexParam createIndexParam = IndexUtils.getCreateIndexParam(entityInfo);
        return IndexUtils.createIndex(this.client, entityInfo, createIndexParam);
    }

    @Override
    public Boolean createIndex(LambdaEsIndexWrapper<T> wrapper) {
        CreateIndexParam createIndexParam = new CreateIndexParam();
        createIndexParam.setIndexName(wrapper.indexName);
        Optional.ofNullable(wrapper.shardsNum).ifPresent(createIndexParam::setShardsNum);
        Optional.ofNullable(wrapper.replicasNum).ifPresent(createIndexParam::setReplicasNum);
        Optional.ofNullable(wrapper.settings).ifPresent(createIndexParam::setSettings);
        List<EsIndexParam> indexParamList = wrapper.esIndexParamList;
        createIndexParam.setEsIndexParamList(indexParamList);
        Optional.ofNullable(wrapper.mapping).ifPresent(createIndexParam::setMapping);
        Optional.ofNullable(wrapper.aliasName).ifPresent(createIndexParam::setAliasName);
        return IndexUtils.createIndex(this.client, EntityInfoHelper.getEntityInfo(this.entityClass), createIndexParam);
    }

    @Override
    public Boolean updateIndex(LambdaEsIndexWrapper<T> wrapper) {
        boolean existsIndex = this.existsIndex(wrapper.indexName);
        if (!existsIndex) {
            throw ExceptionUtils.eee((String)"index: %s not exists", (Object[])new Object[]{wrapper.indexName});
        }
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{wrapper.indexName});
        if (Objects.isNull(wrapper.mapping)) {
            if (CollectionUtils.isEmpty(wrapper.esIndexParamList)) {
                return Boolean.FALSE;
            }
            Map<String, Object> mapping = IndexUtils.initMapping(EntityInfoHelper.getEntityInfo(this.entityClass), wrapper.esIndexParamList);
            putMappingRequest.source(mapping);
        } else {
            putMappingRequest.source(wrapper.mapping);
        }
        try {
            AcknowledgedResponse acknowledgedResponse = this.client.indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
            return acknowledgedResponse.isAcknowledged();
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"update index exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    @Override
    public Boolean deleteIndex(String indexName) {
        if (StringUtils.isEmpty((CharSequence)indexName)) {
            throw ExceptionUtils.eee((String)"indexName can not be empty", (Object[])new Object[0]);
        }
        return IndexUtils.deleteIndex(this.client, indexName);
    }

    @Override
    public SearchResponse search(LambdaEsQueryWrapper<T> wrapper) {
        SearchResponse response;
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(wrapper.indexName)});
        SearchSourceBuilder searchSourceBuilder = WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass);
        searchRequest.source(searchSourceBuilder);
        this.printDSL(searchRequest);
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"search exception", (Throwable)e, (Object[])new Object[0]);
        }
        return response;
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest, RequestOptions requestOptions) throws IOException {
        this.printDSL(searchRequest);
        return this.client.search(searchRequest, requestOptions);
    }

    @Override
    public SearchResponse scroll(SearchScrollRequest searchScrollRequest, RequestOptions requestOptions) throws IOException {
        return this.client.scroll(searchScrollRequest, requestOptions);
    }

    @Override
    public SearchSourceBuilder getSearchSourceBuilder(LambdaEsQueryWrapper<T> wrapper) {
        return WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass);
    }

    @Override
    public String getSource(LambdaEsQueryWrapper<T> wrapper) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(wrapper.indexName)});
        SearchSourceBuilder searchSourceBuilder = WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass);
        searchRequest.source(searchSourceBuilder);
        return Optional.ofNullable(searchRequest.source()).map(SearchSourceBuilder::toString).orElseThrow(() -> ExceptionUtils.eee((String)"get search source exception", (Object[])new Object[0]));
    }

    @Override
    public PageInfo<T> pageQuery(LambdaEsQueryWrapper<T> wrapper, Integer pageNum, Integer pageSize) {
        pageNum = pageNum == null || pageNum <= BaseEsConstants.ZERO ? BaseEsConstants.PAGE_NUM : pageNum;
        pageSize = pageSize == null || pageSize <= BaseEsConstants.ZERO ? BaseEsConstants.PAGE_SIZE : pageSize;
        wrapper.from((pageNum - 1) * pageSize);
        wrapper.size(pageSize);
        SearchResponse response = this.getSearchResponse(wrapper);
        SearchHit[] searchHits = this.parseSearchHitArray(response);
        List dataList = Arrays.stream(searchHits).map(searchHit -> this.parseOne((SearchHit)searchHit, wrapper)).collect(Collectors.toList());
        long count = this.parseCount(response, Objects.nonNull(wrapper.distinctField));
        return PageHelper.getPageInfo(dataList, count, pageNum, pageSize);
    }

    @Override
    public Long selectCount(LambdaEsQueryWrapper<T> wrapper, boolean distinct) {
        CountResponse count;
        wrapper.select(new String[]{"_id"});
        if (distinct) {
            SearchResponse response = this.getSearchResponse(wrapper);
            return this.parseCount(response, Objects.nonNull(wrapper.distinctField));
        }
        CountRequest countRequest = new CountRequest(new String[]{this.getIndexName(wrapper.indexName)});
        BoolQueryBuilder boolQueryBuilder = WrapperProcessor.initBoolQueryBuilder(wrapper.baseEsParamList, wrapper.enableMust2Filter, this.entityClass);
        countRequest.query((QueryBuilder)boolQueryBuilder);
        try {
            this.printCountDSL(countRequest);
            count = this.client.count(countRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"selectCount exception", (Throwable)e, (Object[])new Object[0]);
        }
        return count.getCount();
    }

    @Override
    public Integer insert(T entity) {
        Assert.notNull(entity, (String)"insert entity must not be null");
        return this.insert(entity, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insert(T entity, String indexName) {
        Assert.notNull(entity, (String)"insert entity must not be null");
        IndexRequest indexRequest = this.buildIndexRequest(entity, indexName);
        indexRequest.setRefreshPolicy(this.getRefreshPolicy());
        try {
            IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
            if (Objects.equals(indexResponse.status(), RestStatus.CREATED)) {
                this.setId(entity, indexResponse.getId());
                return BaseEsConstants.ONE;
            }
            if (Objects.equals(indexResponse.status(), RestStatus.OK)) {
                return BaseEsConstants.ZERO;
            }
            throw ExceptionUtils.eee((String)"insert failed, result:%s entity:%s", (Object[])new Object[]{indexResponse.getResult(), entity});
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"insert entity:%s exception", (Throwable)e, (Object[])new Object[]{entity.toString()});
        }
    }

    @Override
    public Integer insertBatch(Collection<T> entityList) {
        return this.insertBatch(entityList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer insertBatch(Collection<T> entityList, String indexName) {
        if (CollectionUtils.isEmpty(entityList)) {
            return BaseEsConstants.ZERO;
        }
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        entityList.forEach(entity -> {
            IndexRequest indexRequest = this.buildIndexRequest(entity, indexName);
            bulkRequest.add(indexRequest);
        });
        return this.doBulkRequest(bulkRequest, RequestOptions.DEFAULT, entityList);
    }

    @Override
    public Integer deleteById(Serializable id) {
        return this.deleteById(id, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer deleteById(Serializable id, String indexName) {
        DeleteRequest deleteRequest = this.generateDelRequest(id, indexName);
        deleteRequest.setRefreshPolicy(this.getRefreshPolicy());
        try {
            DeleteResponse deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
            if (Objects.equals(deleteResponse.status(), RestStatus.OK)) {
                return BaseEsConstants.ONE;
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"deleteById exception, id:%s", (Throwable)e, (Object[])new Object[]{id.toString()});
        }
        return BaseEsConstants.ZERO;
    }

    @Override
    public Integer delete(LambdaEsQueryWrapper<T> wrapper) {
        wrapper.select(new String[]{EntityInfoHelper.getEntityInfo(this.entityClass).getKeyProperty()});
        List<Object> list = this.selectList(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return BaseEsConstants.ZERO;
        }
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        Method getId = BaseCache.getterMethod(this.entityClass, this.getRealIdFieldName());
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        list.forEach(item -> {
            try {
                Object id = getId.invoke(item, new Object[0]);
                if (Objects.nonNull(id)) {
                    DeleteRequest deleteRequest = new DeleteRequest();
                    deleteRequest.id(id.toString());
                    if (entityInfo.isChild()) {
                        String routing = this.getRouting(item, entityInfo.getJoinFieldClass());
                        deleteRequest.routing(routing);
                    }
                    deleteRequest.index(this.getIndexName(wrapper.indexName));
                    bulkRequest.add(deleteRequest);
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.eee((String)"delete exception", (Throwable)e, (Object[])new Object[0]);
            }
        });
        return this.doBulkRequest(bulkRequest, RequestOptions.DEFAULT);
    }

    @Override
    public Integer deleteBatchIds(Collection<? extends Serializable> idList) {
        return this.deleteBatchIds(idList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer deleteBatchIds(Collection<? extends Serializable> idList, String indexName) {
        Assert.notEmpty(idList, (String)"the collection of id must not empty");
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        idList.forEach(id -> {
            DeleteRequest deleteRequest = this.generateDelRequest((Serializable)id, indexName);
            bulkRequest.add(deleteRequest);
        });
        return this.doBulkRequest(bulkRequest, RequestOptions.DEFAULT);
    }

    @Override
    public Integer updateById(T entity) {
        return this.updateById(entity, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer updateById(T entity, String indexName) {
        String idValue = this.getIdValue(entity);
        UpdateRequest updateRequest = this.buildUpdateRequest(entity, idValue, indexName);
        updateRequest.setRefreshPolicy(this.getRefreshPolicy());
        try {
            UpdateResponse updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
            if (Objects.equals(updateResponse.status(), RestStatus.OK)) {
                return BaseEsConstants.ONE;
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"updateById exception,entity:%s", (Throwable)e, (Object[])new Object[]{entity.toString()});
        }
        return BaseEsConstants.ZERO;
    }

    @Override
    public Integer updateBatchByIds(Collection<T> entityList) {
        return this.updateBatchByIds(entityList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public Integer updateBatchByIds(Collection<T> entityList, String indexName) {
        if (CollectionUtils.isEmpty(entityList)) {
            return BaseEsConstants.ZERO;
        }
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        entityList.forEach(entity -> {
            String idValue = this.getIdValue(entity);
            UpdateRequest updateRequest = this.buildUpdateRequest(entity, idValue, indexName);
            bulkRequest.add(updateRequest);
        });
        return this.doBulkRequest(bulkRequest, RequestOptions.DEFAULT);
    }

    @Override
    public Integer update(T entity, LambdaEsUpdateWrapper<T> updateWrapper) {
        if (Objects.isNull(entity) && CollectionUtils.isEmpty(updateWrapper.updateParamList)) {
            return BaseEsConstants.ZERO;
        }
        List<Object> list = this.selectListByUpdateWrapper(updateWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return BaseEsConstants.ZERO;
        }
        String jsonData = Optional.ofNullable(entity).map(this::buildJsonIndexSource).orElseGet(() -> this.buildJsonDoc(updateWrapper));
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(this.getRefreshPolicy());
        String index = this.getIndexName(updateWrapper.indexName);
        Method getId = BaseCache.getterMethod(this.entityClass, this.getRealIdFieldName());
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        list.forEach(item -> {
            UpdateRequest updateRequest = new UpdateRequest();
            try {
                Object invoke = getId.invoke(item, new Object[0]);
                Optional.ofNullable(invoke).ifPresent(id -> updateRequest.id(id.toString()));
            }
            catch (Exception e) {
                throw ExceptionUtils.eee((String)"update exception", (Throwable)e, (Object[])new Object[0]);
            }
            updateRequest.index(index);
            updateRequest.doc(jsonData, XContentType.JSON);
            if (entityInfo.isChild()) {
                String routing = this.getRouting(item, entityInfo.getJoinFieldClass());
                updateRequest.routing(routing);
            }
            bulkRequest.add(updateRequest);
        });
        return this.doBulkRequest(bulkRequest, RequestOptions.DEFAULT);
    }

    @Override
    public T selectById(Serializable id) {
        return this.selectById(id, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public T selectById(Serializable id, String indexName) {
        if (Objects.isNull(id) || StringUtils.isEmpty((CharSequence)id.toString())) {
            throw ExceptionUtils.eee((String)"id must not be null or empty", (Object[])new Object[0]);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(indexName)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"_id", (Object)id));
        searchRequest.source(searchSourceBuilder);
        Object[] searchHits = this.getSearchHitArray(searchRequest);
        if (ArrayUtils.isEmpty((Object[])searchHits)) {
            return null;
        }
        return this.parseOne((SearchHit)searchHits[0]);
    }

    @Override
    public List<T> selectBatchIds(Collection<? extends Serializable> idList) {
        return this.selectBatchIds(idList, EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName());
    }

    @Override
    public List<T> selectBatchIds(Collection<? extends Serializable> idList, String indexName) {
        if (CollectionUtils.isEmpty(idList)) {
            throw ExceptionUtils.eee((String)"id collection must not be null or empty", (Object[])new Object[0]);
        }
        List stringIdList = idList.stream().map(Object::toString).collect(Collectors.toList());
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(indexName)});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termsQuery((String)"_id", stringIdList));
        searchRequest.source(sourceBuilder);
        Object[] searchHitArray = this.getSearchHitArray(searchRequest);
        if (ArrayUtils.isEmpty((Object[])searchHitArray)) {
            return new ArrayList(0);
        }
        return Arrays.stream(searchHitArray).map(this::parseOne).collect(Collectors.toList());
    }

    @Override
    public T selectOne(LambdaEsQueryWrapper<T> wrapper) {
        boolean invalid;
        SearchResponse searchResponse = this.getSearchResponse(wrapper);
        long count = this.parseCount(searchResponse, Objects.nonNull(wrapper.distinctField));
        boolean bl = invalid = count > (long)BaseEsConstants.ONE.intValue() && Objects.nonNull(wrapper.size) && wrapper.size > BaseEsConstants.ONE || count > (long)BaseEsConstants.ONE.intValue() && Objects.isNull(wrapper.size);
        if (invalid) {
            LogUtils.error((String[])new String[]{"found more than one result:" + count, "please use wrapper.limit to limit 1"});
            throw ExceptionUtils.eee((String)"found more than one result: %d, please use wrapper.limit to limit 1", (Object[])new Object[]{count});
        }
        Object[] searchHits = this.parseSearchHitArray(searchResponse);
        if (ArrayUtils.isEmpty((Object[])searchHits)) {
            return null;
        }
        return this.parseOne((SearchHit)searchHits[0], wrapper);
    }

    @Override
    public List<T> selectList(LambdaEsQueryWrapper<T> wrapper) {
        Object[] searchHits = this.getSearchHitArray(wrapper);
        if (ArrayUtils.isEmpty((Object[])searchHits)) {
            return new ArrayList(0);
        }
        return Arrays.stream(searchHits).map(searchHit -> this.parseOne((SearchHit)searchHit, wrapper)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean setCurrentActiveIndex(String indexName) {
        BaseEsMapperImpl baseEsMapperImpl = this;
        synchronized (baseEsMapperImpl) {
            EntityInfoHelper.getEntityInfo(this.entityClass).setIndexName(indexName);
        }
        return Boolean.TRUE;
    }

    private DeleteRequest generateDelRequest(Serializable id, String indexName) {
        if (Objects.isNull(id) || StringUtils.isEmpty((CharSequence)id.toString())) {
            throw ExceptionUtils.eee((String)"id must not be null or empty", (Object[])new Object[0]);
        }
        DeleteRequest deleteRequest = new DeleteRequest();
        deleteRequest.id(id.toString());
        deleteRequest.index(this.getIndexName(indexName));
        return deleteRequest;
    }

    private List<T> selectListByUpdateWrapper(LambdaEsUpdateWrapper<T> wrapper) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(wrapper.indexName)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.fetchSource("_id", null);
        BoolQueryBuilder boolQueryBuilder = WrapperProcessor.initBoolQueryBuilder(wrapper.baseEsParamList, wrapper.enableMust2Filter, this.entityClass);
        Optional.ofNullable(wrapper.geoParam).ifPresent(geoParam -> WrapperProcessor.setGeoQuery(geoParam, boolQueryBuilder, this.entityClass));
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        this.printDSL(searchRequest);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHit[] searchHits = this.parseSearchHitArray(searchResponse);
            return Arrays.stream(searchHits).map(this::parseOne).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"selectIdList exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private IndexRequest buildIndexRequest(T entity, String indexName) {
        IndexRequest indexRequest = new IndexRequest();
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        if (IdType.UUID.equals((Object)entityInfo.getIdType())) {
            indexRequest.id(UUID.randomUUID().toString());
        } else if (IdType.CUSTOMIZE.equals((Object)entityInfo.getIdType())) {
            indexRequest.id(this.getIdValue(entity));
        }
        String jsonData = this.buildJsonIndexSource(entity);
        indexName = StringUtils.isBlank((CharSequence)indexName) ? entityInfo.getIndexName() : indexName;
        indexRequest.index(indexName);
        indexRequest.source(jsonData, XContentType.JSON);
        if (entityInfo.isChild()) {
            String routing = this.getRouting(entity, entityInfo.getJoinFieldClass());
            indexRequest.routing(routing);
        }
        return indexRequest;
    }

    private UpdateRequest buildUpdateRequest(T entity, String idValue, String indexName) {
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.id(idValue);
        updateRequest.index(this.getIndexName(indexName));
        String jsonData = this.buildJsonIndexSource(entity);
        updateRequest.doc(jsonData, XContentType.JSON);
        return updateRequest;
    }

    private long parseCount(SearchResponse response, boolean distinct) {
        AtomicLong repeatNum = new AtomicLong(0L);
        if (distinct) {
            Optional.ofNullable(response.getAggregations()).ifPresent(aggregations -> {
                ParsedCardinality parsedCardinality = (ParsedCardinality)aggregations.get("repeat_num");
                Optional.ofNullable(parsedCardinality).ifPresent(p -> repeatNum.getAndAdd(p.getValue()));
            });
        } else {
            Optional.ofNullable(response.getHits()).flatMap(searchHits -> Optional.ofNullable(searchHits.getTotalHits())).ifPresent(totalHits -> repeatNum.getAndAdd(totalHits.value));
        }
        return repeatNum.get();
    }

    private T parseOne(SearchHit searchHit) {
        Object entity = JSON.parseObject((String)searchHit.getSourceAsString(), this.entityClass, (ParseProcess)EntityInfoHelper.getEntityInfo(this.entityClass).getExtraProcessor(), (Feature[])new Feature[0]);
        this.setId(entity, searchHit.getId());
        return (T)entity;
    }

    private T parseOne(SearchHit searchHit, LambdaEsQueryWrapper<T> wrapper) {
        boolean includeId;
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        Object entity = JSON.parseObject((String)searchHit.getSourceAsString(), this.entityClass, (ParseProcess)entityInfo.getExtraProcessor(), (Feature[])new Feature[0]);
        if (CollectionUtils.isNotEmpty(entityInfo.getHighLightParams())) {
            Map<String, String> highlightFieldMap = this.getHighlightFieldMap();
            Map highlightFields = searchHit.getHighlightFields();
            highlightFields.forEach((key, value) -> {
                String highLightValue = Arrays.stream(value.getFragments()).findFirst().map(Text::string).orElse("");
                this.setHighlightValue(entity, (String)highlightFieldMap.get(key), highLightValue);
            });
        }
        if (includeId = WrapperProcessor.includeId(this.getRealIdFieldName(), wrapper)) {
            this.setId(entity, searchHit.getId());
        }
        return (T)entity;
    }

    private SearchResponse getSearchResponse(LambdaEsQueryWrapper<T> wrapper) {
        return this.search(wrapper);
    }

    private SearchHit[] getSearchHitArray(SearchRequest searchRequest) {
        SearchResponse searchResponse;
        this.printDSL(searchRequest);
        try {
            searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"getSearchHitArray exception,searchRequest:%s", (Throwable)e, (Object[])new Object[]{searchRequest.toString()});
        }
        return this.parseSearchHitArray(searchResponse);
    }

    private SearchHit[] getSearchHitArray(LambdaEsQueryWrapper<T> wrapper) {
        SearchResponse response;
        SearchRequest searchRequest = new SearchRequest(new String[]{this.getIndexName(wrapper.indexName)});
        SearchSourceBuilder searchSourceBuilder = WrapperProcessor.buildSearchSourceBuilder(wrapper, this.entityClass);
        searchRequest.source(searchSourceBuilder);
        this.printDSL(searchRequest);
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"getSearchHitArray IOException, searchRequest:%s", (Throwable)e, (Object[])new Object[]{searchRequest.toString()});
        }
        return this.parseSearchHitArray(response);
    }

    private String buildJsonIndexSource(T entity) {
        EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
        List<EntityFieldInfo> fieldList = entityInfo.getFieldList();
        HashSet excludeColumn = new HashSet();
        fieldList.forEach(field -> {
            String column = field.getColumn();
            Method invokeMethod = BaseCache.getterMethod(this.entityClass, column);
            FieldStrategy fieldStrategy = field.getFieldStrategy();
            try {
                if (FieldStrategy.NOT_NULL.equals((Object)fieldStrategy)) {
                    Object invoke = invokeMethod.invoke(entity, new Object[0]);
                    if (Objects.isNull(invoke)) {
                        excludeColumn.add(column);
                    }
                } else if (FieldStrategy.NOT_EMPTY.equals((Object)fieldStrategy)) {
                    String strValue;
                    Object invoke = invokeMethod.invoke(entity, new Object[0]);
                    if (Objects.isNull(invoke)) {
                        excludeColumn.add(column);
                    } else if (invoke instanceof String && StringUtils.isEmpty((CharSequence)(strValue = (String)invoke))) {
                        excludeColumn.add(column);
                    }
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.eee((String)"buildJsonIndexSource exception, entity:%s", (Throwable)e, (Object[])new Object[]{entity.toString()});
            }
        });
        ArrayList serializeFilters = new ArrayList();
        Optional.ofNullable(entityInfo.getClassSimplePropertyPreFilterMap().get(this.entityClass)).ifPresent(serializeFilters::addAll);
        SimplePropertyPreFilter simplePropertyPreFilter = FastJsonUtils.getSimplePropertyPreFilter(entity.getClass(), excludeColumn);
        Optional.ofNullable(simplePropertyPreFilter).ifPresent(serializeFilters::add);
        return JSON.toJSONString(entity, (SerializeFilter[])serializeFilters.toArray(new SerializeFilter[0]), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    private String buildJsonDoc(LambdaEsUpdateWrapper<T> updateWrapper) {
        List<EsUpdateParam> updateParamList = updateWrapper.updateParamList;
        JSONObject jsonObject = new JSONObject();
        updateParamList.forEach(esUpdateParam -> {
            String realField = FieldUtils.getRealFieldNotConvertId(esUpdateParam.getField(), EntityInfoHelper.getEntityInfo(this.entityClass).getMappingColumnMap(), GlobalConfigCache.getGlobalConfig().getDbConfig());
            jsonObject.put(realField, esUpdateParam.getValue());
        });
        return JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
    }

    private int doBulkRequest(BulkRequest bulkRequest, RequestOptions requestOptions) {
        int totalSuccess = 0;
        try {
            BulkResponse bulkResponse = this.client.bulk(bulkRequest, requestOptions);
            if (bulkResponse.hasFailures()) {
                LogUtils.error((String[])new String[]{bulkResponse.buildFailureMessage()});
            }
            Iterator iterator = bulkResponse.iterator();
            while (iterator.hasNext()) {
                if (!Objects.equals(((BulkItemResponse)iterator.next()).status(), RestStatus.OK)) continue;
                ++totalSuccess;
            }
        }
        catch (IOException e) {
            LogUtils.error((String[])new String[]{"bulk request exception", JSON.toJSONString((Object)e)});
        }
        return totalSuccess;
    }

    private int doBulkRequest(BulkRequest bulkRequest, RequestOptions requestOptions, Collection<T> entityList) {
        int totalSuccess = 0;
        try {
            BulkResponse bulkResponse = this.client.bulk(bulkRequest, requestOptions);
            if (bulkResponse.hasFailures()) {
                LogUtils.error((String[])new String[]{bulkResponse.buildFailureMessage()});
            }
            for (BulkItemResponse next : bulkResponse) {
                if (!Objects.equals(next.status(), RestStatus.CREATED)) continue;
                this.setId(entityList.toArray()[totalSuccess], next.getId());
                ++totalSuccess;
            }
        }
        catch (IOException e) {
            throw ExceptionUtils.eee((String)"bulkRequest exception", (Throwable)e, (Object[])new Object[0]);
        }
        return totalSuccess;
    }

    private SearchHit[] parseSearchHitArray(SearchResponse searchResponse) {
        return Optional.ofNullable(searchResponse).map(SearchResponse::getHits).map(SearchHits::getHits).orElseThrow(() -> ExceptionUtils.eee((String)"parseSearchHitArray exception", (Object[])new Object[0]));
    }

    private String getIndexName(String indexName) {
        if (StringUtils.isBlank((CharSequence)indexName)) {
            return EntityInfoHelper.getEntityInfo(this.entityClass).getIndexName();
        }
        return indexName;
    }

    private String getRealIdFieldName() {
        return EntityInfoHelper.getEntityInfo(this.entityClass).getKeyProperty();
    }

    private Map<String, String> getHighlightFieldMap() {
        return EntityInfoHelper.getEntityInfo(this.entityClass).getHighlightFieldMap();
    }

    private void setHighlightValue(T entity, String highlightField, String value) {
        try {
            Method invokeMethod = BaseCache.setterMethod(this.entityClass, highlightField);
            invokeMethod.invoke(entity, value);
        }
        catch (Throwable e) {
            LogUtils.error((String[])new String[]{"setHighlightValue error,entity:{},highlightField:{},value:{},e:{}", entity.toString(), highlightField, value, e.toString()});
        }
    }

    private void setId(Object entity, String id) {
        try {
            Method invokeMethod = BaseCache.setterMethod(entity.getClass(), this.getRealIdFieldName());
            Class<?> idClass = EntityInfoHelper.getEntityInfo(entity.getClass()).getIdClass();
            Object val = ReflectionKit.getVal((String)id, idClass);
            invokeMethod.invoke(entity, val);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private String getIdValue(T entity) {
        try {
            EntityInfo entityInfo = EntityInfoHelper.getEntityInfo(this.entityClass);
            Field keyField = Optional.ofNullable(entityInfo.getKeyField()).orElseThrow(() -> ExceptionUtils.eee((String)"the entity id field not found", (Object[])new Object[0]));
            Object value = keyField.get(entity);
            return Optional.ofNullable(value).map(Object::toString).orElseThrow(() -> ExceptionUtils.eee((String)"the entity id must not be null", (Object[])new Object[0]));
        }
        catch (IllegalAccessException e) {
            throw ExceptionUtils.eee((String)"get id value exception", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void printCountDSL(CountRequest countRequest) {
        if (GlobalConfigCache.getGlobalConfig().isPrintDsl() && Objects.nonNull(countRequest)) {
            Optional.ofNullable(countRequest.query()).ifPresent(source -> LogUtils.info((String[])new String[]{"===> Execute Count DSL By Easy-Es(Note that size does not affect the total count): " + source}));
        }
    }

    private void printDSL(SearchRequest searchRequest) {
        if (GlobalConfigCache.getGlobalConfig().isPrintDsl() && Objects.nonNull(searchRequest)) {
            Optional.ofNullable(searchRequest.source()).ifPresent(source -> LogUtils.info((String[])new String[]{"===> Execute DSL By Easy-Es: " + source}));
        }
    }

    private String getRefreshPolicy() {
        return GlobalConfigCache.getGlobalConfig().getDbConfig().getRefreshPolicy().getValue();
    }

    private String getRouting(T entity, Class<?> joinFieldClass) {
        Method getJoinFieldMethod = BaseCache.getterMethod(this.entityClass, joinFieldClass.getSimpleName());
        Method getParentMethod = BaseCache.getterMethod(joinFieldClass, "parent");
        try {
            Object joinField = getJoinFieldMethod.invoke(entity, new Object[0]);
            Object parent = getParentMethod.invoke(joinField, new Object[0]);
            return parent.toString();
        }
        catch (Throwable e) {
            LogUtils.error((String[])new String[]{"build IndexRequest: child routing invoke error, joinFieldClass:{},entity:{},e:{}", joinFieldClass.toString(), entity.toString(), e.toString()});
            throw ExceptionUtils.eee((String)"getRouting error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void setClient(RestHighLevelClient client) {
        this.client = client;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }
}

