/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.toolkit;

import cn.easyes.common.enums.EsAttachTypeEnum;
import cn.easyes.common.enums.EsQueryTypeEnum;
import cn.easyes.common.enums.JoinTypeEnum;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.BaseEsParam;
import cn.easyes.core.biz.EntityInfo;
import cn.easyes.core.config.GlobalConfig;
import cn.easyes.core.toolkit.FieldUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.join.query.HasChildQueryBuilder;
import org.elasticsearch.join.query.HasParentQueryBuilder;
import org.elasticsearch.join.query.ParentIdQueryBuilder;

public class EsQueryTypeUtil {
    public static void addQueryByType(BoolQueryBuilder boolQueryBuilder, Integer attachType, boolean enableMust2Filter, BaseEsParam.FieldValueModel model, EntityInfo entityInfo, GlobalConfig.DbConfig dbConfig) {
        Integer queryType = model.getEsQueryType();
        Object value = model.getValue();
        Float boost = model.getBoost();
        String path = model.getPath();
        Integer originalAttachType = model.getOriginalAttachType();
        String field = model.getField();
        field = StringUtils.isBlank((CharSequence)path) ? FieldUtils.getRealField(field, entityInfo.getMappingColumnMap(), dbConfig) : FieldUtils.getRealField(field, entityInfo.getNestedMappingColumnMapByPath(path), dbConfig);
        if (Objects.equals(queryType, EsQueryTypeEnum.TERM_QUERY.getType())) {
            TermQueryBuilder termQueryBuilder = (TermQueryBuilder)QueryBuilders.termQuery((String)field, (Object)value).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)termQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.TERMS_QUERY.getType())) {
            Collection<Object> values = Objects.isNull(value) ? model.getValues() : (Collection)value;
            TermsQueryBuilder termsQueryBuilder = (TermsQueryBuilder)QueryBuilders.termsQuery((String)field, values).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)termsQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.MATCH_PHASE.getType())) {
            MatchPhraseQueryBuilder matchPhraseQueryBuilder = (MatchPhraseQueryBuilder)QueryBuilders.matchPhraseQuery((String)field, (Object)value).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)matchPhraseQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.MATCH_PHRASE_PREFIX.getType())) {
            MatchPhrasePrefixQueryBuilder matchPhrasePrefixQueryBuilder = (MatchPhrasePrefixQueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)field, (Object)value).maxExpansions(((Integer)model.getExt()).intValue()).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)matchPhrasePrefixQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.PREFIX_QUERY.getType())) {
            PrefixQueryBuilder prefixQueryBuilder = (PrefixQueryBuilder)QueryBuilders.prefixQuery((String)field, (String)value.toString()).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)prefixQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.QUERY_STRING_QUERY.getType())) {
            QueryStringQueryBuilder queryStringQueryBuilder = (QueryStringQueryBuilder)QueryBuilders.queryStringQuery((String)value.toString()).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)queryStringQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.MATCH_QUERY.getType())) {
            MatchQueryBuilder matchQueryBuilder = (MatchQueryBuilder)QueryBuilders.matchQuery((String)field, (Object)value).boost(boost.floatValue());
            if (StringUtils.isBlank((CharSequence)path)) {
                EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)matchQueryBuilder);
            } else if (JoinTypeEnum.NESTED.equals(model.getExt())) {
                matchQueryBuilder = (MatchQueryBuilder)QueryBuilders.matchQuery((String)(path + "." + field), (Object)value).boost(boost.floatValue());
                NestedQueryBuilder nestedQueryBuilder = QueryBuilders.nestedQuery((String)model.getPath(), (QueryBuilder)matchQueryBuilder, (ScoreMode)((ScoreMode)model.getScoreMode()));
                EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)nestedQueryBuilder);
            } else if (JoinTypeEnum.HAS_CHILD.equals(model.getExt())) {
                HasChildQueryBuilder hasChildQueryBuilder = (HasChildQueryBuilder)new HasChildQueryBuilder(path, (QueryBuilder)matchQueryBuilder, (ScoreMode)model.getScoreMode()).boost(boost.floatValue());
                EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)hasChildQueryBuilder);
            } else if (JoinTypeEnum.HAS_PARENT.equals(model.getExt())) {
                HasParentQueryBuilder hasParentQueryBuilder = (HasParentQueryBuilder)new HasParentQueryBuilder(path, (QueryBuilder)matchQueryBuilder, ((Boolean)model.getScoreMode()).booleanValue()).boost(boost.floatValue());
                EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)hasParentQueryBuilder);
            } else if (JoinTypeEnum.PARENT_ID.equals(model.getExt())) {
                ParentIdQueryBuilder parentIdQueryBuilder = (ParentIdQueryBuilder)new ParentIdQueryBuilder(path, model.getValue().toString()).boost(boost.floatValue());
                EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)parentIdQueryBuilder);
            }
        } else if (Objects.equals(queryType, EsQueryTypeEnum.RANGE_QUERY.getType())) {
            RangeQueryBuilder rangeQueryBuilder = (RangeQueryBuilder)QueryBuilders.rangeQuery((String)field).boost(boost.floatValue());
            if (Objects.equals(originalAttachType, EsAttachTypeEnum.GT.getType())) {
                rangeQueryBuilder.gt(value);
            } else if (Objects.equals(originalAttachType, EsAttachTypeEnum.LT.getType())) {
                rangeQueryBuilder.lt(value);
            } else if (Objects.equals(originalAttachType, EsAttachTypeEnum.GE.getType())) {
                rangeQueryBuilder.gte(value);
            } else if (Objects.equals(originalAttachType, EsAttachTypeEnum.LE.getType())) {
                rangeQueryBuilder.lte(value);
            }
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)rangeQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.EXISTS_QUERY.getType())) {
            ExistsQueryBuilder existsQueryBuilder = (ExistsQueryBuilder)QueryBuilders.existsQuery((String)field).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)existsQueryBuilder);
        } else if (Objects.equals(queryType, EsQueryTypeEnum.WILDCARD_QUERY.getType())) {
            String query = Objects.equals(attachType, EsAttachTypeEnum.LIKE_LEFT.getType()) ? "*" + value : (Objects.equals(attachType, EsAttachTypeEnum.LIKE_RIGHT.getType()) ? value + "*" : "*" + value + "*");
            WildcardQueryBuilder wildcardQueryBuilder = (WildcardQueryBuilder)QueryBuilders.wildcardQuery((String)field, (String)query).boost(boost.floatValue());
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)wildcardQueryBuilder);
        }
    }

    public static void addQueryByType(BoolQueryBuilder boolQueryBuilder, Integer queryType, Integer attachType, boolean enableMust2Filter, List<String> fields, Object value, Object ext, Integer minShouldMatch, Float boost) {
        if (Objects.equals(queryType, EsQueryTypeEnum.MULTI_MATCH_QUERY.getType())) {
            MultiMatchQueryBuilder multiMatchQueryBuilder = (MultiMatchQueryBuilder)QueryBuilders.multiMatchQuery((Object)value, (String[])fields.toArray(new String[0])).boost(boost.floatValue());
            if (ext instanceof Operator) {
                Operator operator = (Operator)ext;
                multiMatchQueryBuilder.operator(operator);
                multiMatchQueryBuilder.minimumShouldMatch(minShouldMatch + "%");
            }
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)multiMatchQueryBuilder);
        }
    }

    public static void addQueryByType(BoolQueryBuilder boolQueryBuilder, Integer queryType, Integer attachType, boolean enableMust2Filter, String field, Object leftValue, Object rightValue, Float boost) {
        if (Objects.equals(queryType, EsQueryTypeEnum.INTERVAL_QUERY.getType())) {
            RangeQueryBuilder rangeQueryBuilder = (RangeQueryBuilder)QueryBuilders.rangeQuery((String)field).boost(boost.floatValue());
            rangeQueryBuilder.gte(leftValue).lte(rightValue);
            EsQueryTypeUtil.setQueryBuilder(boolQueryBuilder, attachType, enableMust2Filter, (QueryBuilder)rangeQueryBuilder);
        }
    }

    private static void setQueryBuilder(BoolQueryBuilder boolQueryBuilder, Integer attachType, boolean enableMust2Filter, QueryBuilder queryBuilder) {
        boolean mustNot;
        boolean must = Objects.equals(attachType, EsAttachTypeEnum.MUST.getType()) || Objects.equals(attachType, EsAttachTypeEnum.GT.getType()) || Objects.equals(attachType, EsAttachTypeEnum.LT.getType()) || Objects.equals(attachType, EsAttachTypeEnum.GE.getType()) || Objects.equals(attachType, EsAttachTypeEnum.LE.getType()) || Objects.equals(attachType, EsAttachTypeEnum.IN.getType()) || Objects.equals(attachType, EsAttachTypeEnum.BETWEEN.getType()) || Objects.equals(attachType, EsAttachTypeEnum.EXISTS.getType()) || Objects.equals(attachType, EsAttachTypeEnum.LIKE_LEFT.getType()) || Objects.equals(attachType, EsAttachTypeEnum.LIKE_RIGHT.getType());
        boolean bl = mustNot = Objects.equals(attachType, EsAttachTypeEnum.MUST_NOT.getType()) || Objects.equals(attachType, EsAttachTypeEnum.NOT_IN.getType()) || Objects.equals(attachType, EsAttachTypeEnum.NOT_EXISTS.getType()) || Objects.equals(attachType, EsAttachTypeEnum.NOT_BETWEEN.getType());
        if (must) {
            if (enableMust2Filter) {
                boolQueryBuilder.filter(queryBuilder);
            } else {
                boolQueryBuilder.must(queryBuilder);
            }
        } else if (Objects.equals(attachType, EsAttachTypeEnum.FILTER.getType())) {
            boolQueryBuilder.filter(queryBuilder);
        } else if (Objects.equals(attachType, EsAttachTypeEnum.SHOULD.getType())) {
            boolQueryBuilder.should(queryBuilder);
        } else if (mustNot) {
            boolQueryBuilder.mustNot(queryBuilder);
        }
    }
}

